/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.common.features.filters;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.block.IBlockHooks;
import net.darkhax.darkutilities.common.Content;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockEntityFilter
extends Block
implements IBlockHooks {
    public static final BlockBehaviour.Properties BLOCK_PROPERTIES = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(3.0f, 10.0f).isSuffocating((a, b, c) -> false).isViewBlocking((a, b, c) -> false).noOcclusion();
    private final Predicate<Entity> filter;

    public static Supplier<Block> of(Predicate<Entity> filter) {
        return () -> new BlockEntityFilter(filter, BLOCK_PROPERTIES);
    }

    public BlockEntityFilter(Predicate<Entity> filter, BlockBehaviour.Properties properties) {
        super(properties);
        this.filter = filter;
        BlockState defaultState = this.defaultBlockState();
        defaultState = (BlockState)defaultState.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false));
        defaultState = (BlockState)defaultState.setValue((Property)BlockStateProperties.INVERTED, (Comparable)Boolean.valueOf(false));
        this.registerDefaultState(defaultState);
        Content.CUTOUT.add(this);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.POWERED, BlockStateProperties.INVERTED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState placedState = super.getStateForPlacement(context);
        if (placedState != null) {
            placedState = (BlockState)placedState.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
        }
        return placedState;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.isCrouching()) {
            if (!world.isClientSide) {
                world.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.INVERTED, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)BlockStateProperties.INVERTED) == false)), 3);
                world.levelEvent(1008, pos, 0);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, world, pos, player, hitResult);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean isBlockPowered = world.hasNeighborSignal(pos);
        if (!world.isClientSide && (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != isBlockPowered) {
            world.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, 0.5f);
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(isBlockPowered)));
        }
        super.neighborChanged(state, world, pos, block, fromPos, isMoving);
    }

    public boolean isPossibleToRespawnInThis(BlockState state) {
        return true;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityContext;
        Entity entity;
        if (!((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue() && context instanceof EntityCollisionContext && (entity = (entityContext = (EntityCollisionContext)context).getEntity()) != null) {
            boolean filterMatch = this.filter.test(entity);
            if ((Boolean)state.getValue((Property)BlockStateProperties.INVERTED) != filterMatch) {
                return Shapes.empty();
            }
        }
        return super.getCollisionShape(state, world, pos, context);
    }

    public boolean skipRendering(BlockState ourState, BlockState neighborState, Direction side) {
        return neighborState.is((Block)this);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }
}

