/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.darkutilities.common.component.NameStyle;
import net.minecraft.class_156;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8059;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import net.minecraft.class_9697;

public class SmithingFontNameRecipe
implements class_8059 {
    public static final class_2960 RECIPE_ID = class_2960.method_60655((String)"darkutils", (String)"smithing_font_name");
    public static final CachedSupplier<class_1865<SmithingFontNameRecipe>> SERIALIZER = CachedSupplier.of((class_2378)class_7923.field_41189, (class_2960)RECIPE_ID).cast();
    private static final HashMap<class_6862<class_1792>, class_1767> COLOR_MAP = (HashMap)class_156.method_656(() -> {
        HashMap<class_6862, class_1767> map = new HashMap<class_6862, class_1767>();
        for (class_1767 color : class_1767.values()) {
            map.put(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"c", (String)("dyes/" + color.method_7792()))), color);
        }
        return map;
    });
    final class_1856 template;
    final class_2960 fontID;

    public static Optional<class_1767> getDyeColor(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1769) {
            class_1769 dye = (class_1769)class_17922;
            return Optional.of(dye.method_7802());
        }
        for (Map.Entry<class_6862<class_1792>, class_1767> entry : COLOR_MAP.entrySet()) {
            if (!stack.method_31573(entry.getKey())) continue;
            return Optional.ofNullable(entry.getValue());
        }
        return Optional.empty();
    }

    public SmithingFontNameRecipe(class_1856 template, class_2960 fontID) {
        this.template = template;
        this.fontID = fontID;
    }

    public boolean matches(class_9697 input, class_1937 level) {
        return !input.comp_2678().method_7960() && this.template.method_8093(input.comp_2677()) && (input.comp_2679().method_7960() || SmithingFontNameRecipe.getDyeColor(input.comp_2679()).isPresent());
    }

    public class_1799 assemble(class_9697 input, class_7225.class_7874 registries) {
        Optional<class_1767> color = SmithingFontNameRecipe.getDyeColor(input.comp_2679());
        class_1799 output = input.comp_2678().method_7972();
        output.method_57379((class_9331)NameStyle.COMPONENT.get(), (Object)new NameStyle(this.fontID, color));
        return output;
    }

    public class_1799 method_8110(class_7225.class_7874 registries) {
        return class_1802.field_8448.method_7854();
    }

    public boolean method_48453(class_1799 stack) {
        return this.template.method_8093(stack);
    }

    public boolean method_48454(class_1799 stack) {
        return true;
    }

    public boolean method_30029(class_1799 stack) {
        return stack.method_7960() || SmithingFontNameRecipe.getDyeColor(stack) != null;
    }

    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    public boolean method_31584() {
        return this.template.method_8103();
    }

    public static class Serializer
    implements class_1865<SmithingFontNameRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<SmithingFontNameRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1856.field_46095.fieldOf("template").forGetter(r -> r.template), (App)class_2960.field_25139.fieldOf("font").forGetter(r -> r.fontID)).apply((Applicative)instance, SmithingFontNameRecipe::new));
        public static final class_9139<class_9129, SmithingFontNameRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<SmithingFontNameRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, SmithingFontNameRecipe> method_56104() {
            return STREAM_CODEC;
        }

        private static SmithingFontNameRecipe fromNetwork(class_9129 buffer) {
            class_1856 template = (class_1856)class_1856.field_48355.decode((Object)buffer);
            class_2960 fontID = buffer.method_10810();
            return new SmithingFontNameRecipe(template, fontID);
        }

        private static void toNetwork(class_9129 buffer, SmithingFontNameRecipe recipe) {
            class_1856.field_48355.encode((Object)buffer, (Object)recipe.template);
            buffer.method_10812(recipe.fontID);
        }
    }
}

