package net.darkhax.darkutilities.common.features.flatblocks;

import java.util.function.Consumer;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_3483;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;

public class FlatTileEffects {

    private static final class_5321<class_8110> FAKE_PLAYER_DAMAGE = class_5321.method_29179(class_7924.field_42534, class_2960.method_60655("bookshelf", "fake_player"));

    public static final BlockFlatTile.CollisionEffect PUSH_WEAK = new CollisionEffectPush(0.06d);
    public static final BlockFlatTile.CollisionEffect PUSH_NORMAL = new CollisionEffectPush(0.3d);
    public static final BlockFlatTile.CollisionEffect PUSH_STRONG = new CollisionEffectPush(1.5d);
    public static final BlockFlatTile.CollisionEffect PUSH_ULTRA = new CollisionEffectPush(7.5d);

    public static final BlockFlatTile.CollisionEffect DAMAGE_GENERIC = livingEffect(e -> e.method_5643(e.method_37908().method_48963().method_48830(), 6f));
    public static final BlockFlatTile.CollisionEffect DAMAGE_MAIM = livingEffect(e -> {
        if (e.method_6032() >= 2f) {
            e.method_5643(e.method_37908().method_48963().method_48830(), 1f);
        }
    });
    public static final BlockFlatTile.CollisionEffect DAMAGE_PLAYER = livingEffect(e -> e.method_5643(getSource(e.method_37908(), FAKE_PLAYER_DAMAGE), 6f));
    public static final BlockFlatTile.CollisionEffect SLOWNESS = statusEffect(class_1294.field_5909, 100, 1);
    public static final BlockFlatTile.CollisionEffect FATIGUE = statusEffect(class_1294.field_5901, 100, 1);
    public static final BlockFlatTile.CollisionEffect DARKNESS = statusEffect(class_1294.field_5919, 100, 1);
    public static final BlockFlatTile.CollisionEffect HUNGER = statusEffect(class_1294.field_5903, 100, 0);
    public static final BlockFlatTile.CollisionEffect WEAKNESS = statusEffect(class_1294.field_5911, 100, 0);
    public static final BlockFlatTile.CollisionEffect POISON = statusEffect(class_1294.field_5899, 100, 0);
    public static final BlockFlatTile.CollisionEffect WITHER = statusEffect(class_1294.field_5920, 100, 0);
    public static final BlockFlatTile.CollisionEffect GLOWING = statusEffect(class_1294.field_5912, 500, 1);
    public static final BlockFlatTile.CollisionEffect LEVITATION = statusEffect(class_1294.field_5902, 100, 1);
    public static final BlockFlatTile.CollisionEffect UNLUCK = statusEffect(class_1294.field_5908, 666, 1);
    public static final BlockFlatTile.CollisionEffect SLOWFALL = statusEffect(class_1294.field_5906, 100, 1);
    public static final BlockFlatTile.CollisionEffect OMEN = statusEffect(class_1294.field_16595, 500, 0);
    public static final BlockFlatTile.CollisionEffect FROST = livingEffect(e -> {

        if (e.method_32316()) {

            e.method_5643(e.method_37908().method_48963().method_48836(), 1f);
            final int existingFrostTicks = e.method_32312();
            e.method_32317(Math.min(existingFrostTicks + 20, 80));
        }
    });
    public static final BlockFlatTile.CollisionEffect FLAME = livingEffect(e -> {
        if (!e.method_5753()) {
            e.method_5643(e.method_37908().method_48963().method_48794(), 1f);
            e.method_5639(4f);
        }
    });
    public static final BlockFlatTile.CollisionEffect SMITE = livingEffect(e -> {
        if (e.method_5864().method_20210(class_3483.field_46232)) {
            e.method_5643(e.method_37908().method_48963().method_48830(), 12f);
        }
    });
    public static final BlockFlatTile.CollisionEffect BANE = livingEffect(e -> {
        if (e.method_5864().method_20210(class_3483.field_48289)) {
            e.method_5643(e.method_37908().method_48963().method_48830(), 12f);
            e.method_6092(new class_1293(class_1294.field_5909, 20, 3));
        }
    });

    public static final BlockFlatTile.CollisionEffect ANCHOR = (state, world, pos, entity) -> {

        if (entity instanceof class_1309 living && !living.method_18276() && !(living instanceof class_1657)) {

            final class_2350 direction = state.method_11654(class_2741.field_12481);
            final class_2338 offset = pos.method_10079(direction.method_10153(), 5);
            living.method_5702(class_2183.class_2184.field_9851, new class_243(offset.method_10263() + 0.5f, offset.method_10264() + 1.5f, offset.method_10260() + 0.5f));
            entity.method_5814(pos.method_10263() + 0.5f, pos.method_10264() + 0.0625D, pos.method_10260() + 0.5f);
        }
    };

    private static BlockFlatTile.CollisionEffect statusEffect(class_6880<class_1291> effect, int duration, int amplifier) {

        return livingEffect(living -> living.method_6092(new class_1293(effect, duration, amplifier)));
    }

    private static BlockFlatTile.CollisionEffect livingEffect(Consumer<class_1309> effect) {

        return (s, w, p, e) -> {

            if (e instanceof class_1309 living) {

                effect.accept(living);
            }
        };
    }

    private static class_1282 getSource(class_1937 level, class_5321<class_8110> id) {

        final class_2378<class_8110> registry = level.method_30349().method_30530(class_7924.field_42534);
        final class_6880.class_6883<class_8110> damage = registry.method_40290(id);
        return new class_1282(damage);
    }
}