package net.darkhax.darkutilities.common.features.flatblocks;

import net.darkhax.bookshelf.common.api.block.IBlockHooks;
import net.minecraft.class_1538;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import java.util.function.Supplier;

public class BlockFlatTileRotatableLightningUpgrade extends BlockFlatTileRotatable implements IBlockHooks {

    private final Supplier<class_2248> upgradeTo;

    public BlockFlatTileRotatableLightningUpgrade(CollisionEffect collisionEffect, Supplier<class_2248> upgradeTo) {
        this(BlockFlatTile.BLOCK_PROPERTIES, collisionEffect, upgradeTo);
    }

    public BlockFlatTileRotatableLightningUpgrade(class_2251 properties, CollisionEffect collisionEffect, Supplier<class_2248> upgradeTo) {
        super(properties, collisionEffect);
        this.upgradeTo = upgradeTo;
    }

    @Override
    public void onLightningStrike(class_2680 state, class_1937 level, class_2338 pos, class_1538 lightning) {
        convertPlates(this.upgradeTo.get(), level, pos, 16);
    }

    @Override
    public void onLightningStrikeIndirect(class_2680 state, class_1937 level, class_2338 pos, class_1538 lightning, class_2338 strikeOrigin) {
        this.onLightningStrike(state, level, pos, lightning);
    }

    private void convertPlates(class_2248 to, class_1937 world, class_2338 startPos, int attempts) {
        final class_2338.class_2339 mutable = startPos.method_25503();
        for (int attempt = 0; attempt < attempts; attempt++) {
            final class_2350 pointing = convertPlates(to, world, mutable);
            if (pointing != null) {
                mutable.method_10098(pointing);
            }
            else {
                return;
            }
        }
    }

    private class_2350 convertPlates(class_2248 to, class_1937 world, class_2338 platePos) {
        final class_2680 state = world.method_8320(platePos);
        if (state.method_27852(this)) {
            final class_2350 plateDirection = state.method_11654(class_2741.field_12481);
            final boolean platePowered = state.method_11654(class_2741.field_12484);
            world.method_8501(platePos, to.method_9564().method_11657(class_2741.field_12481, plateDirection).method_11657(class_2741.field_12484, platePowered));
            world.method_20290(3002, platePos, -1);
            return plateDirection;
        }
        return null;
    }
}