package net.darkhax.darkutilities.common.features.flatblocks;

import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2390;
import net.minecraft.class_2398;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_9062;

public class BlockFlatTile extends class_2248 implements class_3737 {

    public static final class_2746 HIDDEN = class_2746.method_11825("hidden");
    public static final class_2746 LOCKED = class_2746.method_11825("locked");
    public static final class_2251 BLOCK_PROPERTIES = class_4970.class_2251.method_9637().method_31710(class_3620.field_33532).method_9629(2f, 10f).method_9634().method_9626(class_2498.field_29035);
    public static final class_265 BOUNDS = class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 1.0D, 16.0D);

    private final CollisionEffect collisionEffect;

    public static Supplier<class_2248> of(CollisionEffect effect) {
        return () -> new BlockFlatTile(BLOCK_PROPERTIES, effect);
    }

    public BlockFlatTile(class_2251 properties, CollisionEffect collisionEffect) {
        super(properties);
        this.collisionEffect = collisionEffect;
        class_2680 defaultState = this.method_9564();
        defaultState = defaultState.method_11657(class_2741.field_12484, false);
        defaultState = defaultState.method_11657(class_2741.field_12508, false);
        defaultState = defaultState.method_11657(HIDDEN, false);
        defaultState = defaultState.method_11657(LOCKED, false);
        this.method_9590(defaultState);
    }

    @Override
    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (this.collisionEffect != null && !state.method_11654(class_2741.field_12484) && entity.method_23318() <= (double) pos.method_10264() + 0.4d) {
            this.collisionEffect.onCollision(state, world, pos, entity);
            if (state.method_11654(HIDDEN)) {
                world.method_20290(3002, pos, -1);
                world.method_8501(pos, state.method_11657(HIDDEN, false));
            }
        }
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(class_2741.field_12484, class_2741.field_12508, HIDDEN, LOCKED);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return BOUNDS;
    }

    @Override
    public boolean method_9538(class_2680 state) {
        return true;
    }

    @Override
    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        if (player.method_5998(hand).method_31574(class_1802.field_8530)) {
            boolean oldValue = state.method_11654(LOCKED);
            level.method_8652(pos, state.method_11657(LOCKED, !oldValue), 2);
            if (level instanceof class_3218 serverLevel) {
                serverLevel.method_14199(!oldValue ? class_2390.field_11188 : class_2398.field_11251, pos.method_10263() + 0.5, pos.method_10264() + 1.2f / 16, pos.method_10260() + 0.5, 16, 0.25, 0, 0.25, 0);
                serverLevel.method_8396(null, pos, class_3417.field_14962, class_3419.field_15245, 0.3f, !oldValue ? 0.6F : 0.5F);
                if (player instanceof class_3222 sPlayer) {
                    sPlayer.method_7353(class_2561.method_43469("block.darkutils.plate." + (!oldValue ? "locked" : "unlocked"), state.method_26204().method_9518()), true);
                }
            }
            return class_9062.field_47728;
        }
        return super.method_55765(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(class_2741.field_12508) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 world, class_2338 currentPos, class_2338 facingPos) {
        if (state.method_11654(class_2741.field_12508)) {
            world.method_39281(currentPos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        return super.method_9559(state, facing, facingState, world, currentPos, facingPos);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        final class_3610 preExistingFluidState = context.method_8045().method_8316(context.method_8037());
        class_2680 placedState = super.method_9605(context);
        if (placedState != null) {
            placedState = placedState.method_11657(class_2741.field_12508, preExistingFluidState.method_39360(class_3612.field_15910));
            placedState = placedState.method_11657(class_2741.field_12484, context.method_8045().method_49803(context.method_8037()));
        }
        return placedState;
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        if (!world.field_9236 && !state.method_11654(LOCKED)) {
            world.method_8652(pos, state.method_11657(class_2741.field_12484, world.method_49803(pos)), 2);
        }
        super.method_9612(state, world, pos, block, fromPos, isMoving);
    }

    @FunctionalInterface
    public interface CollisionEffect {
        void onCollision(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity);
    }
}