package net.darkhax.darkutilities.common.features.filters;

import java.util.function.Predicate;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1427;
import net.minecraft.class_1429;
import net.minecraft.class_1480;
import net.minecraft.class_1551;
import net.minecraft.class_1569;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3483;
import net.minecraft.class_3988;
import net.minecraft.class_6862;
import net.minecraft.class_7102;

public class Filters {

    public static final Predicate<class_1297> PLAYER = e -> e instanceof class_1657;
    public static final Predicate<class_1297> UNDEAD = tagFilter(class_3483.field_46232);
    public static final Predicate<class_1297> ARTHROPOD = tagFilter(class_3483.field_48289);
    public static final Predicate<class_1297> ILLAGER = tagFilter(class_3483.field_48287);
    public static final Predicate<class_1297> RAIDER = tagFilter(class_3483.field_19168);
    public static final Predicate<class_1297> HOSTILE = e -> e instanceof class_1569;
    public static final Predicate<class_1297> ANIMAL = e -> e instanceof class_1429;
    public static final Predicate<class_1297> BABY = e -> e instanceof class_1296 ageable && ageable.method_6109();
    public static final Predicate<class_1297> PET = e -> e instanceof class_1321;
    public static final Predicate<class_1297> SLIME = e -> e instanceof class_1621;
    public static final Predicate<class_1297> VILLAGER = e -> e instanceof class_3988;
    public static final Predicate<class_1297> FIRE_IMMUNE = e -> e instanceof class_1309 living && (living.method_5753() || living.method_6059(class_1294.field_5918));
    public static final Predicate<class_1297> GOLEM = e -> e instanceof class_1427;
    public static final Predicate<class_1297> WATER = e -> e instanceof class_1480 || e.method_5864().method_20210(class_3483.field_48288) || e instanceof class_1551 || e instanceof class_7102;
    public static final Predicate<class_1297> NAMED = class_1297::method_16914;
    public static final Predicate<class_1297> FREEZE_IMMUNE = tagFilter(class_3483.field_29825);
    public static final Predicate<class_1297> EQUIPMENT = hasEquipment();
    public static final Predicate<class_1297> PASSENGER = e -> e.method_5765() || !e.method_5685().isEmpty();

    private static Predicate<class_1297> tagFilter(class_6862<class_1299<?>> tag) {
        return e -> e.method_5864().method_20210(tag);
    }

    private static Predicate<class_1297> hasEquipment() {
        return e -> {
            if (e instanceof class_1309 living) {
                for (class_1799 armor : living.method_5661()) {
                    if (!armor.method_7960()) {
                        return true;
                    }
                }
                for (class_1799 held : living.method_5877()) {
                    if (!held.method_7960()) {
                        return true;
                    }
                }
            }
            return false;
        };
    }
}