package net.darkhax.darkutilities.common.features.charms;

import net.darkhax.darkutilities.common.mixin.AccessorMobEffectInstance;
import net.darkhax.darkutilities.common.mixin.AccessorPlayer;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_4081;

public enum CharmEffects {

    PRIDE(CharmEffects::prideCharmTick),
    Sloth(CharmEffects::slothCharmTick),
    Gluttony(CharmEffects::gluttonyCharmTick);

    public final CharmEffect effect;

    CharmEffects(CharmEffect effect) {
        this.effect = effect;
    }

    private static void prideCharmTick(class_1799 stack, class_1937 level, class_1309 user) {
        if (user instanceof class_1309 living && !living.method_6026().isEmpty()) {
            for (class_1293 effectInstance : living.method_6026()) {
                final class_1291 effect = effectInstance.method_5579().comp_349();
                if (!effectInstance.method_5591() && effect.method_18792() == class_4081.field_18272 && !effect.method_5561() && effectInstance instanceof AccessorMobEffectInstance accessor) {
                    accessor.darkutils$tickDownDuration();
                }
            }
        }
    }

    private static void slothCharmTick(class_1799 stack, class_1937 level, class_1309 user) {
        if (user instanceof class_1657 player) {
            if (player.method_6113() && player instanceof AccessorPlayer accessor && player.method_7297() < 90) {
                // Allow the player to skip the bed timer and instantly go to sleep.
                accessor.darkutils$setSleepTimer(90);
            }
            if (player instanceof class_3222 splayer) {
                // Phantoms and other mods use this stat to handle negative insomnia effects. Setting it to 0 ensures the player is always considered well rested.
                splayer.method_14248().method_15023(player, class_3468.field_15419.method_14956(class_3468.field_15429), 0);
            }
        }
    }

    private static void gluttonyCharmTick(class_1799 stack, class_1937 level, class_1309 user) {
    }

    public static boolean hasCharm(class_1309 entity, class_1792 charm) {
        if (entity instanceof class_1657 player) {
            for (class_1799 stack : player.method_31548().field_7547) {
                if (stack.method_31574(charm)) {
                    return true;
                }
            }
        }
        else {
            for (class_1799 stack : entity.method_56675()) {
                if (stack.method_31574(charm)) {
                    return true;
                }
            }
        }
        return false;
    }
}