/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.darkutilities.common.component.NameStyle;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.Level;

public class SmithingFontNameRecipe
implements SmithingRecipe {
    public static final ResourceLocation RECIPE_ID = ResourceLocation.fromNamespaceAndPath((String)"darkutils", (String)"smithing_font_name");
    public static final CachedSupplier<RecipeSerializer<SmithingFontNameRecipe>> SERIALIZER = CachedSupplier.of((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (ResourceLocation)RECIPE_ID).cast();
    private static final HashMap<TagKey<Item>, DyeColor> COLOR_MAP = (HashMap)Util.make(() -> {
        HashMap<TagKey, DyeColor> map = new HashMap<TagKey, DyeColor>();
        for (DyeColor color : DyeColor.values()) {
            map.put(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dyes/" + color.getName()))), color);
        }
        return map;
    });
    final Ingredient template;
    final ResourceLocation fontID;

    public static Optional<DyeColor> getDyeColor(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            return Optional.of(dye.getDyeColor());
        }
        for (Map.Entry<TagKey<Item>, DyeColor> entry : COLOR_MAP.entrySet()) {
            if (!stack.is(entry.getKey())) continue;
            return Optional.ofNullable(entry.getValue());
        }
        return Optional.empty();
    }

    public SmithingFontNameRecipe(Ingredient template, ResourceLocation fontID) {
        this.template = template;
        this.fontID = fontID;
    }

    public boolean matches(SmithingRecipeInput input, Level level) {
        return !input.base().isEmpty() && this.template.test(input.template()) && (input.addition().isEmpty() || SmithingFontNameRecipe.getDyeColor(input.addition()).isPresent());
    }

    public ItemStack assemble(SmithingRecipeInput input, HolderLookup.Provider registries) {
        Optional<DyeColor> color = SmithingFontNameRecipe.getDyeColor(input.addition());
        ItemStack output = input.base().copy();
        output.set((DataComponentType)NameStyle.COMPONENT.get(), (Object)new NameStyle(this.fontID, color));
        return output;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return Items.NAME_TAG.getDefaultInstance();
    }

    public boolean isTemplateIngredient(ItemStack stack) {
        return this.template.test(stack);
    }

    public boolean isBaseIngredient(ItemStack stack) {
        return true;
    }

    public boolean isAdditionIngredient(ItemStack stack) {
        return stack.isEmpty() || SmithingFontNameRecipe.getDyeColor(stack) != null;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public boolean isIncomplete() {
        return this.template.isEmpty();
    }

    public static class Serializer
    implements RecipeSerializer<SmithingFontNameRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<SmithingFontNameRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("template").forGetter(r -> r.template), (App)ResourceLocation.CODEC.fieldOf("font").forGetter(r -> r.fontID)).apply((Applicative)instance, SmithingFontNameRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingFontNameRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<SmithingFontNameRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SmithingFontNameRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static SmithingFontNameRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient template = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ResourceLocation fontID = buffer.readResourceLocation();
            return new SmithingFontNameRecipe(template, fontID);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, SmithingFontNameRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.template);
            buffer.writeResourceLocation(recipe.fontID);
        }
    }
}

