/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.common.features.charms;

import net.darkhax.darkutilities.common.features.charms.CharmEffect;
import net.darkhax.darkutilities.common.mixin.AccessorMobEffectInstance;
import net.darkhax.darkutilities.common.mixin.AccessorPlayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public enum CharmEffects {
    PRIDE(CharmEffects::prideCharmTick),
    Sloth(CharmEffects::slothCharmTick),
    Gluttony(CharmEffects::gluttonyCharmTick);

    public final CharmEffect effect;

    private CharmEffects(CharmEffect effect) {
        this.effect = effect;
    }

    private static void prideCharmTick(ItemStack stack, Level level, LivingEntity user) {
        LivingEntity living;
        if (user instanceof LivingEntity && !(living = user).getActiveEffects().isEmpty()) {
            for (MobEffectInstance effectInstance : living.getActiveEffects()) {
                MobEffect effect = (MobEffect)effectInstance.getEffect().value();
                if (effectInstance.isAmbient() || effect.getCategory() != MobEffectCategory.HARMFUL || effect.isInstantenous() || !(effectInstance instanceof AccessorMobEffectInstance)) continue;
                AccessorMobEffectInstance accessor = (AccessorMobEffectInstance)effectInstance;
                accessor.darkutils$tickDownDuration();
            }
        }
    }

    private static void slothCharmTick(ItemStack stack, Level level, LivingEntity user) {
        if (user instanceof Player) {
            Player player = (Player)user;
            if (player.isSleeping() && player instanceof AccessorPlayer) {
                AccessorPlayer accessor = (AccessorPlayer)player;
                if (player.getSleepTimer() < 90) {
                    accessor.darkutils$setSleepTimer(90);
                }
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer splayer = (ServerPlayer)player;
                splayer.getStats().setValue(player, Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST), 0);
            }
        }
    }

    private static void gluttonyCharmTick(ItemStack stack, Level level, LivingEntity user) {
    }

    public static boolean hasCharm(LivingEntity entity, Item charm) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ItemStack stack : player.getInventory().items) {
                if (!stack.is(charm)) continue;
                return true;
            }
        } else {
            for (ItemStack stack : entity.getAllSlots()) {
                if (!stack.is(charm)) continue;
                return true;
            }
        }
        return false;
    }
}

