/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.badmobs.config;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobSpawnType;
import net.neoforged.neoforge.common.ModConfigSpec;

public class SpawnConfig {
    private final ModConfigSpec.BooleanValue allowNormalSpawn;
    private final ModConfigSpec.BooleanValue allowSpawners;
    private final ModConfigSpec.BooleanValue allowSpawnEggs;
    private final ModConfigSpec.BooleanValue allowConversions;

    public SpawnConfig(ResourceLocation id, ModConfigSpec.Builder builder) {
        builder.comment("Options for the " + id.getNamespace() + " mod.");
        builder.push(id.getNamespace());
        builder.comment("Spawning options for " + String.valueOf(id));
        builder.push(id.getPath());
        builder.comment("Should the entity be allowed to spawn normally?");
        this.allowNormalSpawn = builder.define("allowNormalSpawning", true);
        builder.comment("Should spawners be able to spawn the entity?");
        this.allowSpawners = builder.define("allowSpawners", true);
        builder.comment("Should spawn eggs be able to spawn the entity?");
        this.allowSpawnEggs = builder.define("allowSpawnEggs", true);
        builder.comment("Should the entity spawn via mob conversion? i.e. villager -> zombie");
        this.allowConversions = builder.define("allowConversions", true);
        builder.pop();
        builder.pop();
    }

    public boolean canSpawn(MobSpawnType reason) {
        if (reason == MobSpawnType.SPAWNER) {
            return (Boolean)this.allowSpawners.get();
        }
        if (reason == MobSpawnType.SPAWN_EGG) {
            return (Boolean)this.allowSpawnEggs.get();
        }
        if (reason == MobSpawnType.CONVERSION) {
            return (Boolean)this.allowConversions.get();
        }
        return (Boolean)this.allowNormalSpawn.get();
    }
}

