/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.repack.registrate.providers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mysticmods.mysticalworld.repack.registrate.AbstractRegistrate;
import mysticmods.mysticalworld.repack.registrate.providers.ProviderType;
import mysticmods.mysticalworld.repack.registrate.providers.RegistrateProvider;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistrateAdvancementProvider
implements RegistrateProvider,
Consumer<Advancement> {
    private static final Logger log = LogManager.getLogger(RegistrateAdvancementProvider.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final AbstractRegistrate<?> owner;
    private final DataGenerator generator;
    @Nullable
    private HashCache cache;
    private Set<ResourceLocation> seenAdvancements = new HashSet<ResourceLocation>();

    public RegistrateAdvancementProvider(AbstractRegistrate<?> owner, DataGenerator generatorIn) {
        this.owner = owner;
        this.generator = generatorIn;
    }

    @Override
    public LogicalSide getSide() {
        return LogicalSide.SERVER;
    }

    public TranslatableComponent title(String category, String name, String title) {
        return this.owner.addLang("advancements", new ResourceLocation(category, name), "title", title);
    }

    public TranslatableComponent desc(String category, String name, String desc) {
        return this.owner.addLang("advancements", new ResourceLocation(category, name), "description", desc);
    }

    public void m_6865_(HashCache cache) throws IOException {
        try {
            this.cache = cache;
            this.seenAdvancements.clear();
            this.owner.genData(ProviderType.ADVANCEMENT, this);
        }
        finally {
            this.cache = null;
        }
    }

    @Override
    public void accept(@Nullable Advancement t) {
        HashCache cache = this.cache;
        if (cache == null) {
            throw new IllegalStateException("Cannot accept advancements outside of act");
        }
        Objects.requireNonNull(t, "Cannot accept a null advancement");
        Path path = this.generator.m_123916_();
        if (!this.seenAdvancements.add(t.m_138327_())) {
            throw new IllegalStateException("Duplicate advancement " + t.m_138327_());
        }
        Path path1 = RegistrateAdvancementProvider.getPath(path, t);
        try {
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)t.m_138313_().m_138400_(), (Path)path1);
        }
        catch (IOException ioexception) {
            log.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
        }
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.m_138327_().m_135827_() + "/advancements/" + advancementIn.m_138327_().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Advancements";
    }
}

