/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.repack.registrate.builders;

import java.util.Arrays;
import java.util.EnumSet;
import mysticmods.mysticalworld.repack.registrate.AbstractRegistrate;
import mysticmods.mysticalworld.repack.registrate.builders.AbstractBuilder;
import mysticmods.mysticalworld.repack.registrate.builders.BuilderCallback;
import mysticmods.mysticalworld.repack.registrate.util.nullness.NonnullType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class EnchantmentBuilder<T extends Enchantment, P>
extends AbstractBuilder<Enchantment, T, P, EnchantmentBuilder<T, P>> {
    private Enchantment.Rarity rarity = Enchantment.Rarity.COMMON;
    private final EnchantmentCategory type;
    private EnumSet<EquipmentSlot> slots = EnumSet.noneOf(EquipmentSlot.class);
    private final EnchantmentFactory<T> factory;

    public static <T extends Enchantment, P> EnchantmentBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, EnchantmentCategory type, EnchantmentFactory<T> factory) {
        return new EnchantmentBuilder<T, P>(owner, parent, name, callback, type, factory).defaultLang();
    }

    protected EnchantmentBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, EnchantmentCategory type, EnchantmentFactory<T> factory) {
        super(owner, parent, name, callback, Enchantment.class);
        this.factory = factory;
        this.type = type;
    }

    public EnchantmentBuilder<T, P> rarity(Enchantment.Rarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public EnchantmentBuilder<T, P> addArmorSlots() {
        return this.addSlots(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
    }

    public EnchantmentBuilder<T, P> addSlots(EquipmentSlot ... slots) {
        this.slots.addAll(Arrays.asList(slots));
        return this;
    }

    public EnchantmentBuilder<T, P> defaultLang() {
        return (EnchantmentBuilder)this.lang(Enchantment::m_44704_);
    }

    public EnchantmentBuilder<T, P> lang(String name) {
        return (EnchantmentBuilder)this.lang(Enchantment::m_44704_, name);
    }

    @Override
    @NonnullType
    protected T createEntry() {
        return this.factory.create(this.rarity, this.type, this.slots.toArray(new EquipmentSlot[0]));
    }

    @FunctionalInterface
    public static interface EnchantmentFactory<T extends Enchantment> {
        public T create(Enchantment.Rarity var1, EnchantmentCategory var2, EquipmentSlot ... var3);
    }
}

