/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.repack.registrate.builders;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import mysticmods.mysticalworld.repack.registrate.AbstractRegistrate;
import mysticmods.mysticalworld.repack.registrate.builders.Builder;
import mysticmods.mysticalworld.repack.registrate.builders.BuilderCallback;
import mysticmods.mysticalworld.repack.registrate.providers.ProviderType;
import mysticmods.mysticalworld.repack.registrate.providers.RegistrateLangProvider;
import mysticmods.mysticalworld.repack.registrate.providers.RegistrateTagsProvider;
import mysticmods.mysticalworld.repack.registrate.util.entry.LazyRegistryEntry;
import mysticmods.mysticalworld.repack.registrate.util.entry.RegistryEntry;
import mysticmods.mysticalworld.repack.registrate.util.nullness.NonNullBiFunction;
import mysticmods.mysticalworld.repack.registrate.util.nullness.NonNullSupplier;
import mysticmods.mysticalworld.repack.registrate.util.nullness.NonnullType;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public abstract class AbstractBuilder<R extends IForgeRegistryEntry<R>, T extends R, P, S extends AbstractBuilder<R, T, P, S>>
implements Builder<R, T, P, S> {
    private final AbstractRegistrate<?> owner;
    private final P parent;
    private final String name;
    private final BuilderCallback callback;
    private final Class<? super R> registryType;
    private final Multimap<ProviderType<? extends RegistrateTagsProvider<?>>, TagKey<?>> tagsByType = HashMultimap.create();
    private final LazyRegistryEntry<T> safeSupplier = new LazyRegistryEntry(this);

    @NonnullType
    protected abstract T createEntry();

    @Override
    public RegistryEntry<T> register() {
        return this.callback.accept(this.name, this.registryType, this, this::createEntry, this::createEntryWrapper);
    }

    protected RegistryEntry<T> createEntryWrapper(RegistryObject<T> delegate) {
        return new RegistryEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public NonNullSupplier<T> asSupplier() {
        return this.safeSupplier;
    }

    @SafeVarargs
    public final S tag(ProviderType<? extends RegistrateTagsProvider<R>> type, TagKey<R> ... tags) {
        if (!this.tagsByType.containsKey(type)) {
            this.setData(type, (ctx, prov) -> this.tagsByType.get((Object)type).stream().map(t -> t).map(prov::m_206424_).forEach(b -> b.m_126582_((Object)((IForgeRegistryEntry)this.asSupplier().get()))));
        }
        this.tagsByType.putAll(type, Arrays.asList(tags));
        return (S)this;
    }

    @SafeVarargs
    public final S removeTag(ProviderType<RegistrateTagsProvider<R>> type, TagKey<R> ... tags) {
        if (this.tagsByType.containsKey(type)) {
            for (TagKey<R> tag : tags) {
                this.tagsByType.remove(type, tag);
            }
        }
        return (S)this;
    }

    public S lang(NonNullFunction<T, String> langKeyProvider) {
        return this.lang(langKeyProvider, (RegistrateLangProvider p, NonNullSupplier<? extends T> t) -> p.getAutomaticName((NonNullSupplier<? extends IForgeRegistryEntry<?>>)t));
    }

    public S lang(NonNullFunction<T, String> langKeyProvider, String name) {
        return this.lang(langKeyProvider, (RegistrateLangProvider p, NonNullSupplier<? extends T> s) -> name);
    }

    private S lang(NonNullFunction<T, String> langKeyProvider, NonNullBiFunction<RegistrateLangProvider, NonNullSupplier<? extends T>, String> localizedNameProvider) {
        return (S)((AbstractBuilder)this.setData(ProviderType.LANG, (ctx, prov) -> prov.add((String)langKeyProvider.apply(ctx.getEntry()), (String)localizedNameProvider.apply((RegistrateLangProvider)prov, ctx::getEntry))));
    }

    public AbstractBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, Class<? super R> registryType) {
        this.owner = owner;
        this.parent = parent;
        this.name = name;
        this.callback = callback;
        this.registryType = registryType;
    }

    @Override
    public AbstractRegistrate<?> getOwner() {
        return this.owner;
    }

    @Override
    public P getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected BuilderCallback getCallback() {
        return this.callback;
    }

    @Override
    public Class<? super R> getRegistryType() {
        return this.registryType;
    }
}

