/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.repack.noobutil.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import mysticmods.mysticalworld.repack.noobutil.reference.ModData;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelUtil {
    private static final Vec3 fromOrigin = new Vec3(-0.5, -0.5, -0.5);

    public static VoxelShape multiOr(VoxelShape base, VoxelShape ... shapes) {
        VoxelShape result = base;
        for (VoxelShape shape : shapes) {
            result = Shapes.m_83110_((VoxelShape)result, (VoxelShape)shape);
        }
        return result;
    }

    public static VoxelShape multiOr(double[] base, double[] ... shapes) {
        VoxelShape result = VoxelUtil.makeCube(base);
        for (double[] shape : shapes) {
            result = Shapes.m_83110_((VoxelShape)result, (VoxelShape)VoxelUtil.makeCube(shape));
        }
        return result;
    }

    public static VoxelShape makeCube(double ... p) {
        return Shapes.m_83048_((double)(p[0] / 16.0), (double)(p[1] / 16.0), (double)(p[2] / 16.0), (double)(p[3] / 16.0), (double)(p[4] / 16.0), (double)(p[5] / 16.0));
    }

    public static void print(double x1, double y1, double z1, double x2, double y2, double z2) {
        ModData.logger.info("makeCuboidShape(" + Math.min(x1, x2) + ", " + Math.min(y1, y2) + ", " + Math.min(z1, z2) + ", " + Math.max(x1, x2) + ", " + Math.max(y1, y2) + ", " + Math.max(z1, z2) + "),");
    }

    public static void printSimplified(String name, VoxelShape shape) {
        ModData.logger.info("Simplified: " + name);
        shape.m_83296_().m_83299_().forEach(box -> VoxelUtil.print(box.f_82288_ * 16.0, box.f_82289_ * 16.0, box.f_82290_ * 16.0, box.f_82291_ * 16.0, box.f_82292_ * 16.0, box.f_82293_ * 16.0));
    }

    public static AABB rotate(AABB box, Direction side) {
        switch (side) {
            case DOWN: {
                return box;
            }
            case UP: {
                return new AABB(box.f_82288_, -box.f_82289_, -box.f_82290_, box.f_82291_, -box.f_82292_, -box.f_82293_);
            }
            case NORTH: {
                return new AABB(box.f_82288_, -box.f_82290_, box.f_82289_, box.f_82291_, -box.f_82293_, box.f_82292_);
            }
            case SOUTH: {
                return new AABB(-box.f_82288_, box.f_82290_, -box.f_82289_, -box.f_82291_, box.f_82293_, -box.f_82292_);
            }
            case WEST: {
                return new AABB(box.f_82289_, -box.f_82290_, -box.f_82288_, box.f_82292_, -box.f_82293_, -box.f_82291_);
            }
            case EAST: {
                return new AABB(-box.f_82289_, box.f_82290_, box.f_82288_, -box.f_82292_, box.f_82293_, box.f_82291_);
            }
        }
        return box;
    }

    public static AABB rotate(AABB box, Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return box;
            }
            case CLOCKWISE_90: {
                return new AABB(-box.f_82290_, box.f_82289_, box.f_82288_, -box.f_82293_, box.f_82292_, box.f_82291_);
            }
            case CLOCKWISE_180: {
                return new AABB(-box.f_82288_, box.f_82289_, -box.f_82290_, -box.f_82291_, box.f_82292_, -box.f_82293_);
            }
            case COUNTERCLOCKWISE_90: {
                return new AABB(box.f_82290_, box.f_82289_, -box.f_82288_, box.f_82293_, box.f_82292_, -box.f_82291_);
            }
        }
        return box;
    }

    public static AABB rotateHorizontal(AABB box, Direction side) {
        switch (side) {
            case NORTH: {
                return VoxelUtil.rotate(box, Rotation.NONE);
            }
            case SOUTH: {
                return VoxelUtil.rotate(box, Rotation.CLOCKWISE_180);
            }
            case WEST: {
                return VoxelUtil.rotate(box, Rotation.COUNTERCLOCKWISE_90);
            }
            case EAST: {
                return VoxelUtil.rotate(box, Rotation.CLOCKWISE_90);
            }
        }
        return box;
    }

    public static VoxelShape rotate(VoxelShape shape, Direction side) {
        return VoxelUtil.rotate(shape, box -> VoxelUtil.rotate(box, side));
    }

    public static VoxelShape rotate(VoxelShape shape, Rotation rotation) {
        return VoxelUtil.rotate(shape, box -> VoxelUtil.rotate(box, rotation));
    }

    public static VoxelShape rotateHorizontal(VoxelShape shape, Direction side) {
        return VoxelUtil.rotate(shape, box -> VoxelUtil.rotateHorizontal(box, side));
    }

    public static VoxelShape rotate(VoxelShape shape, UnaryOperator<AABB> rotateFunction) {
        ArrayList<VoxelShape> rotatedPieces = new ArrayList<VoxelShape>();
        List sourceBoundingBoxes = shape.m_83299_();
        for (AABB sourceBoundingBox : sourceBoundingBoxes) {
            rotatedPieces.add(Shapes.m_83064_((AABB)((AABB)rotateFunction.apply(sourceBoundingBox.m_82386_(VoxelUtil.fromOrigin.f_82479_, VoxelUtil.fromOrigin.f_82480_, VoxelUtil.fromOrigin.f_82481_))).m_82386_(-VoxelUtil.fromOrigin.f_82479_, -VoxelUtil.fromOrigin.f_82481_, -VoxelUtil.fromOrigin.f_82481_)));
        }
        return VoxelUtil.combine(rotatedPieces);
    }

    public static VoxelShape combine(VoxelShape ... shapes) {
        return VoxelUtil.batchCombine(Shapes.m_83040_(), BooleanOp.f_82695_, true, shapes);
    }

    public static VoxelShape combine(Collection<VoxelShape> shapes) {
        return VoxelUtil.combine(shapes, true);
    }

    public static VoxelShape combine(Collection<VoxelShape> shapes, boolean simplify) {
        return VoxelUtil.batchCombine(Shapes.m_83040_(), BooleanOp.f_82695_, simplify, shapes);
    }

    public static VoxelShape exclude(VoxelShape ... shapes) {
        return VoxelUtil.batchCombine(Shapes.m_83144_(), BooleanOp.f_82685_, true, shapes);
    }

    public static VoxelShape batchCombine(VoxelShape initial, BooleanOp function, boolean simplify, Collection<VoxelShape> shapes) {
        VoxelShape combinedShape = initial;
        for (VoxelShape shape : shapes) {
            combinedShape = Shapes.m_83148_((VoxelShape)combinedShape, (VoxelShape)shape, (BooleanOp)function);
        }
        return simplify ? combinedShape.m_83296_() : combinedShape;
    }

    public static VoxelShape batchCombine(VoxelShape initial, BooleanOp function, boolean simplify, VoxelShape ... shapes) {
        VoxelShape combinedShape = initial;
        for (VoxelShape shape : shapes) {
            combinedShape = Shapes.m_83148_((VoxelShape)combinedShape, (VoxelShape)shape, (BooleanOp)function);
        }
        return simplify ? combinedShape.m_83296_() : combinedShape;
    }

    private static Vector3f rotateVector(float x, float y, float z, float rotateAngleX, float rotateAngleY, float rotateAngleZ) {
        float xReturn = x;
        float yReturn = y;
        float zReturn = z;
        if (rotateAngleZ != 0.0f) {
            float sinZ = (float)Math.sin(rotateAngleZ);
            float cosZ = (float)Math.cos(rotateAngleZ);
            xReturn = x * cosZ - y * sinZ;
            yReturn = x * sinZ + y * cosZ;
            x = xReturn;
            y = yReturn;
        }
        if (rotateAngleY != 0.0f) {
            float sinY = (float)Math.sin(rotateAngleY);
            float cosY = (float)Math.cos(rotateAngleY);
            xReturn = x * cosY + z * sinY;
            z = zReturn = z * cosY - x * sinY;
        }
        if (rotateAngleX != 0.0f) {
            float sinX = (float)Math.sin(rotateAngleX);
            float cosX = (float)Math.cos(rotateAngleX);
            yReturn = y * cosX - z * sinX;
            zReturn = y * sinX + z * cosX;
        }
        return new Vector3f(xReturn, yReturn, zReturn);
    }

    private static class Vector3f {
        public final float x;
        public final float y;
        public final float z;

        public Vector3f(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Vector3f scale(float factor) {
            return this.mul(factor, factor, factor);
        }

        public Vector3f subtract(Vector3f vec) {
            return this.subtract(vec.x, vec.y, vec.z);
        }

        public Vector3f subtract(float x, float y, float z) {
            return this.add(-x, -y, -z);
        }

        public Vector3f add(Vector3f vec) {
            return this.add(vec.x, vec.y, vec.z);
        }

        public Vector3f add(float x, float y, float z) {
            return new Vector3f(this.x + x, this.y + y, this.z + z);
        }

        public Vector3f mul(float factorX, float factorY, float factorZ) {
            return new Vector3f(this.x * factorX, this.y * factorY, this.z * factorZ);
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ", " + this.z + ")";
        }
    }

    @FunctionalInterface
    public static interface ShapeCreator {
        public VoxelShape createShape(float var1, float var2, float var3);
    }
}

