/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.repack.noobutil.registry;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import mysticmods.mysticalworld.repack.noobutil.reference.ModData;
import mysticmods.mysticalworld.repack.noobutil.type.LazySupplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public class ConfiguredRegistry<T> {
    private final Map<ResourceLocation, Entry<T>> entries = new ConcurrentHashMap<ResourceLocation, Entry<T>>();
    private final Registry<T> registry;
    private boolean registered = false;

    public ConfiguredRegistry(Registry<T> registry) {
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry<T> register(String name, Supplier<T> value) {
        Map<ResourceLocation, Entry<T>> map = this.entries;
        synchronized (map) {
            ResourceLocation rl = new ResourceLocation(ModData.getModid(), name);
            if (this.entries.containsKey(rl)) {
                throw new IllegalArgumentException("Key '" + rl + "' already exists for '" + this.registry + "'");
            }
            Entry<T> result = new Entry<T>(value, new ResourceLocation(ModData.getModid(), name));
            this.entries.put(rl, result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() {
        Map<ResourceLocation, Entry<T>> map = this.entries;
        synchronized (map) {
            if (this.registered) {
                throw new IllegalStateException("Attempted to register configured registry " + this + " when it has already been marked as registered.");
            }
            for (Map.Entry<ResourceLocation, Entry<T>> entry : this.entries.entrySet()) {
                entry.getValue().registered = true;
                T value = entry.getValue().get();
                Registry.m_122965_(this.registry, (ResourceLocation)entry.getKey(), value);
            }
            this.registered = true;
        }
    }

    public static class Entry<T>
    extends LazySupplier<T> {
        private boolean registered = false;
        private final ResourceLocation rl;

        public Entry(Supplier<T> supplierIn, ResourceLocation rl) {
            super(supplierIn);
            this.rl = rl;
        }

        @Override
        public T get() {
            if (!this.isRegistered()) {
                throw new IllegalStateException("Tried to access entry '" + this.rl + "' before initialization");
            }
            return super.get();
        }

        public boolean isRegistered() {
            return this.registered;
        }

        public ResourceLocation getId() {
            return this.rl;
        }
    }
}

