/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.repack.noobutil.material;

import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mysticmods.mysticalworld.repack.noobutil.config.IArmorConfig;
import mysticmods.mysticalworld.repack.noobutil.ingredient.LazyIngredient;
import mysticmods.mysticalworld.repack.noobutil.item.WeaponType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MaterialType {
    public static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    public static final UUID MAIN_HAND_MODIFIER = UUID.fromString("0e2c39ce-5247-4095-abf7-d99bd7387a95");
    public static final UUID OFF_HAND_MODIFIER = UUID.fromString("28ad5d13-618f-4c80-8f60-0e0469c1a046");
    private static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    private final String name;
    private Tier tier = null;
    private ArmorMaterial material = null;
    private int maxUses;
    private float efficiency;
    private float attackDamage;
    private int harvestLevel;
    private int enchantability;
    private float knockbackResistance;
    private LazyIngredient repairMaterial;
    private int maxDamageFactor;
    private int[] damageReductionAmountArray;
    private SoundEvent soundEvent;
    private float toughness;
    private Supplier<Supplier<? extends Item>> item;
    private Supplier<Supplier<? extends Item>> dust;
    private Supplier<Supplier<? extends Item>> nugget;
    private Supplier<Supplier<? extends Block>> block;
    private Supplier<Supplier<? extends Block>> ore;
    private int maxXP = 0;
    private int minXP = 0;
    private String modId;
    private Object2FloatOpenHashMap<WeaponType> damage = new Object2FloatOpenHashMap();
    private Object2FloatOpenHashMap<WeaponType> speed = new Object2FloatOpenHashMap();
    private List<WeaponType> itemTypes;
    private ArmorMaterial armorMaterial = new ArmorMaterial();
    private ItemMaterial itemMaterial = new ItemMaterial();
    private Function<String, IArmorConfig> configProvider = null;

    public MaterialType(String name) {
        this.name = name;
        this.putDamageSpeed(new Object[]{WeaponType.SWORD, Float.valueOf(3.0f), Float.valueOf(-2.4f), WeaponType.SHOVEL, Float.valueOf(1.5f), Float.valueOf(-3.0f), WeaponType.PICKAXE, Float.valueOf(1.0f), Float.valueOf(-2.8f), WeaponType.HOE, Float.valueOf(1.0f), Float.valueOf(-1.0f)});
    }

    public ArmorMaterial getArmorMaterial() {
        return this.armorMaterial;
    }

    public ItemMaterial getItemMaterial() {
        return this.itemMaterial;
    }

    public MaterialType setModId(String modId) {
        this.modId = modId;
        return this;
    }

    public String getModId() {
        return this.modId;
    }

    public MaterialType itemMaterial(int maxUses, float efficiency, float attackDamage, int harvestLevel, int enchantability) {
        this.maxUses = maxUses;
        this.efficiency = efficiency;
        this.attackDamage = attackDamage;
        this.harvestLevel = harvestLevel;
        this.enchantability = enchantability;
        this.repairMaterial = new LazyIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)this.item.get().get()}));
        return this;
    }

    public MaterialType itemMaterial(int maxUses, float efficiency, float attackDamage, int harvestLevel, int enchantability, Supplier<TagKey<Item>> repairTag) {
        this.itemMaterial(maxUses, efficiency, attackDamage, harvestLevel, enchantability);
        this.repairMaterial = new LazyIngredient(() -> Ingredient.m_204132_((TagKey)((TagKey)repairTag.get())));
        return this;
    }

    public MaterialType itemMaterial(int maxUses, float efficiency, float attackDamage, int harvestLevel, int enchantability, Ingredient repairMaterial) {
        this.itemMaterial(maxUses, efficiency, attackDamage, harvestLevel, enchantability);
        this.repairMaterial = repairMaterial instanceof LazyIngredient ? (LazyIngredient)repairMaterial : new LazyIngredient(() -> repairMaterial);
        return this;
    }

    public MaterialType armorMaterial(int maxDamageFactor, int[] damageReductionAmountArray, SoundEvent soundEvent, float toughness, float knockbackResistance) {
        this.maxDamageFactor = maxDamageFactor;
        this.damageReductionAmountArray = damageReductionAmountArray;
        this.soundEvent = soundEvent;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        return this;
    }

    public MaterialType setItemTier(Tier tier) {
        this.tier = tier;
        return this;
    }

    public MaterialType setArmorMaterial(ArmorMaterial material) {
        this.material = material;
        return this;
    }

    public MaterialType setConfigProvider(Function<String, IArmorConfig> configProvider) {
        this.configProvider = configProvider;
        return this;
    }

    public int getMaxXP() {
        return this.maxXP;
    }

    public MaterialType setMaxXP(int maxXP) {
        this.maxXP = maxXP;
        return this;
    }

    public int getMinXP() {
        return this.minXP;
    }

    public MaterialType setMinXP(int minXP) {
        this.minXP = minXP;
        return this;
    }

    public MaterialType putDamageSpeed(Object ... entries) {
        if (entries.length % 3 != 0) {
            throw new IllegalArgumentException("Invalid number of arguments to putDamageSpeed");
        }
        for (int i = 0; i < entries.length; i += 3) {
            WeaponType type = (WeaponType)((Object)entries[i]);
            float damage = ((Float)entries[i + 1]).floatValue();
            float speed = ((Float)entries[i + 2]).floatValue();
            this.damage.put((Object)type, damage);
            this.speed.put((Object)type, speed);
        }
        return this;
    }

    public int getDamage(WeaponType type) {
        return (int)this.damage.getOrDefault((Object)type, 1.0f);
    }

    public int getDamage(String type) {
        return this.getDamage(WeaponType.byName(type));
    }

    public float getSpeed(WeaponType type) {
        return this.speed.getOrDefault((Object)type, -1.0f);
    }

    public float getSpeed(String type) {
        return this.getSpeed(WeaponType.byName(type));
    }

    public List<WeaponType> getItemTypes() {
        return this.itemTypes;
    }

    public MaterialType setItemTypes(WeaponType ... types) {
        this.itemTypes = Arrays.asList(types);
        return this;
    }

    public String getInternalName() {
        return this.name;
    }

    public String getIngotName() {
        return this.name + "_ingot";
    }

    public Supplier<? extends Item> getItem() {
        return this.item.get();
    }

    public Supplier<? extends Item> getDust() {
        return this.dust.get();
    }

    public Supplier<? extends Item> getNugget() {
        return this.nugget.get();
    }

    public Supplier<? extends Block> getBlock() {
        return this.block.get();
    }

    public Supplier<? extends Block> getOre() {
        return this.ore.get();
    }

    public MaterialType item(Supplier<Supplier<? extends Item>> ingot) {
        this.item = ingot;
        return this;
    }

    public MaterialType dust(Supplier<Supplier<? extends Item>> dust) {
        this.dust = dust;
        return this;
    }

    public MaterialType nugget(Supplier<Supplier<? extends Item>> nugget) {
        this.nugget = nugget;
        return this;
    }

    public MaterialType block(Supplier<Supplier<? extends Block>> block) {
        this.block = block;
        return this;
    }

    public MaterialType ore(Supplier<Supplier<? extends Block>> ore) {
        this.ore = ore;
        return this;
    }

    public BlockBehaviour.Properties getBlockProps(BlockBehaviour.Properties props) {
        return props.m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_);
    }

    public Supplier<BlockBehaviour.Properties> getBlockProps() {
        return () -> this.getBlockProps(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_));
    }

    public BlockBehaviour.Properties getOreBlockProperties(BlockBehaviour.Properties props) {
        return props.m_60913_(3.0f, 3.0f).m_60999_();
    }

    public Supplier<BlockBehaviour.Properties> getOreBlockProperties() {
        return () -> this.getOreBlockProperties(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_));
    }

    public int getHarvestLevel() {
        return this.tier == null ? this.harvestLevel : this.tier.m_6604_();
    }

    public String gemName() {
        return this.name + "_gem";
    }

    public String ingotName() {
        return this.name + "_ingot";
    }

    public String dustName() {
        return this.name + "_dust";
    }

    public String blockName() {
        return this.name + "_block";
    }

    public String oreName() {
        return this.name + "_ore";
    }

    public String nuggetName() {
        return this.name + "_nugget";
    }

    public class ArmorMaterial
    implements net.minecraft.world.item.ArmorMaterial {
        public int m_7366_(EquipmentSlot slotIn) {
            return MaterialType.this.material == null ? MAX_DAMAGE_ARRAY[slotIn.m_20749_()] * MaterialType.this.maxDamageFactor : MaterialType.this.material.m_7366_(slotIn);
        }

        public int m_7365_(EquipmentSlot slotIn) {
            IArmorConfig config;
            if (MaterialType.this.configProvider != null && (config = MaterialType.this.configProvider.apply(MaterialType.this.name)) != null) {
                if (slotIn == EquipmentSlot.HEAD) {
                    return config.getHead();
                }
                if (slotIn == EquipmentSlot.FEET) {
                    return config.getFeet();
                }
                if (slotIn == EquipmentSlot.CHEST) {
                    return config.getChest();
                }
                if (slotIn == EquipmentSlot.LEGS) {
                    return config.getLegs();
                }
            }
            return MaterialType.this.material == null ? MaterialType.this.damageReductionAmountArray[slotIn.m_20749_()] : MaterialType.this.material.m_7365_(slotIn);
        }

        public SoundEvent m_7344_() {
            return MaterialType.this.material == null ? MaterialType.this.soundEvent : MaterialType.this.material.m_7344_();
        }

        public float m_6651_() {
            IArmorConfig config;
            if (MaterialType.this.configProvider != null && (config = MaterialType.this.configProvider.apply(MaterialType.this.name)) != null) {
                return config.getToughness();
            }
            return MaterialType.this.material == null ? MaterialType.this.toughness : MaterialType.this.material.m_6651_();
        }

        public float m_6649_() {
            return MaterialType.this.material == null ? MaterialType.this.knockbackResistance : MaterialType.this.material.m_6649_();
        }

        @Nonnull
        public Ingredient m_6230_() {
            return MaterialType.this.tier == null ? MaterialType.this.repairMaterial : MaterialType.this.tier.m_6282_();
        }

        public int m_6646_() {
            return MaterialType.this.tier == null ? MaterialType.this.enchantability : MaterialType.this.tier.m_6601_();
        }

        @OnlyIn(value=Dist.CLIENT)
        public String m_6082_() {
            return MaterialType.this.getModId() + ":" + MaterialType.this.getInternalName();
        }
    }

    public class ItemMaterial
    implements Tier {
        public int m_6609_() {
            return MaterialType.this.tier == null ? MaterialType.this.maxUses : MaterialType.this.tier.m_6609_();
        }

        public float m_6624_() {
            return MaterialType.this.tier == null ? MaterialType.this.efficiency : MaterialType.this.tier.m_6624_();
        }

        public float m_6631_() {
            return MaterialType.this.tier == null ? MaterialType.this.attackDamage : MaterialType.this.tier.m_6631_();
        }

        public int m_6604_() {
            return MaterialType.this.getHarvestLevel();
        }

        public int m_6601_() {
            return MaterialType.this.tier == null ? MaterialType.this.enchantability : MaterialType.this.tier.m_6601_();
        }

        @Nonnull
        public Ingredient m_6282_() {
            return MaterialType.this.tier == null ? MaterialType.this.repairMaterial : MaterialType.this.tier.m_6282_();
        }
    }
}

