/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.repack.noobutil.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mysticmods.mysticalworld.repack.noobutil.reference.ModData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class ExcludingIngredient
extends Ingredient {
    private final ExcludingItemList excludingItemList;

    public static ExcludingIngredient create(TagKey<Item> base, ItemLike without) {
        return new ExcludingIngredient(Ingredient.m_204132_(base), Ingredient.m_43929_((ItemLike[])new ItemLike[]{without}));
    }

    public static ExcludingIngredient create(TagKey<Item> base, TagKey<Item> without) {
        return new ExcludingIngredient(Ingredient.m_204132_(base), Ingredient.m_204132_(without));
    }

    private ExcludingIngredient(Ingredient base, Ingredient without) {
        this(new ExcludingItemList(base, without));
    }

    private ExcludingIngredient(ExcludingItemList excludingItemList) {
        super(Stream.of(excludingItemList));
        this.excludingItemList = excludingItemList;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        return this.excludingItemList.base.test(stack) && !this.excludingItemList.without.test(stack);
    }

    public boolean m_43947_() {
        return this.m_43908_().length == 0;
    }

    public boolean isSimple() {
        return this.excludingItemList.base.isSimple() && this.excludingItemList.without.isSimple();
    }

    public IIngredientSerializer<ExcludingIngredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    private static class ExcludingItemList
    implements Ingredient.Value {
        private final Ingredient base;
        private final Ingredient without;

        public ExcludingItemList(Ingredient base, Ingredient without) {
            this.base = base;
            this.without = without;
        }

        public Collection<ItemStack> m_6223_() {
            return Arrays.stream(this.base.m_43908_()).filter(stack -> !this.without.test(stack)).collect(Collectors.toList());
        }

        public JsonObject m_6544_() {
            JsonObject json = new JsonObject();
            json.addProperty("type", ModData.getResourceLocation("excluding_ingredient").toString());
            json.add("base", this.base.m_43942_());
            json.add("without", this.without.m_43942_());
            return json;
        }
    }

    public static class Serializer
    implements IIngredientSerializer<ExcludingIngredient> {
        public static final IIngredientSerializer<ExcludingIngredient> INSTANCE = new Serializer();

        private Serializer() {
        }

        public ExcludingIngredient parse(@Nonnull JsonObject json) {
            if (json.has("base") && json.has("without")) {
                return new ExcludingIngredient(Ingredient.m_43917_((JsonElement)json.getAsJsonObject("base")), Ingredient.m_43917_((JsonElement)json.getAsJsonObject("without")));
            }
            throw new JsonParseException("A without ingredient must have both a base ingredient and a negation ingredient.");
        }

        public ExcludingIngredient parse(@Nonnull FriendlyByteBuf buffer) {
            Ingredient base = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient without = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return new ExcludingIngredient(base, without);
        }

        public void write(@Nonnull FriendlyByteBuf buffer, ExcludingIngredient ingredient) {
            CraftingHelper.write((FriendlyByteBuf)buffer, (Ingredient)ingredient.excludingItemList.base);
            CraftingHelper.write((FriendlyByteBuf)buffer, (Ingredient)ingredient.excludingItemList.without);
        }
    }
}

