/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.repack.noobutil.data.generator;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mysticmods.mysticalworld.repack.noobutil.item.BaseItems;
import mysticmods.mysticalworld.repack.registrate.providers.DataGenContext;
import mysticmods.mysticalworld.repack.registrate.providers.RegistrateRecipeProvider;
import mysticmods.mysticalworld.repack.registrate.util.DataIngredient;
import mysticmods.mysticalworld.repack.registrate.util.entry.RegistryEntry;
import mysticmods.mysticalworld.repack.registrate.util.nullness.NonNullBiConsumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeGenerator {
    private String modid;

    public RecipeGenerator(String modid) {
        this.modid = modid;
    }

    public ResourceLocation rl(String comp) {
        if (comp.contains(":")) {
            return new ResourceLocation(this.modid, comp.split(":")[1]);
        }
        return new ResourceLocation(this.modid, comp);
    }

    public ResourceLocation getId(TagKey<Item> tag) {
        return tag.f_203868_();
    }

    public <T extends Item> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateRecipeProvider> storage(Supplier<RegistryEntry<Block>> block, Supplier<RegistryEntry<Item>> ingot, TagKey<Item> blockTag, TagKey<Item> ingotTag, @Nullable TagKey<Item> oreTag, @Nullable Supplier<RegistryEntry<Item>> nugget, @Nullable TagKey<Item> nuggetTag, @Nullable TagKey<Item> dustTag) {
        return (ctx, p) -> {
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)((RegistryEntry)block.get()).get())).m_126130_("###").m_126130_("###").m_126130_("###").m_206416_(Character.valueOf('#'), ingotTag).m_142284_("has_at_least_9_" + this.safeName(this.getId(ingotTag)), (CriterionTriggerInstance)DataIngredient.tag(ingotTag).getCritereon((RegistrateRecipeProvider)p)).m_142700_((Consumer)p, this.rl(this.safeName(this.getId(ingotTag)) + "_to_storage_block"));
            ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)((RegistryEntry)ingot.get()).get()), (int)9).m_206419_(blockTag).m_142284_("has_block_" + this.safeName(this.getId(blockTag)), (CriterionTriggerInstance)DataIngredient.tag(blockTag).getCritereon((RegistrateRecipeProvider)p)).m_142700_((Consumer)p, this.rl(this.safeName(this.getId(blockTag)) + "_to_9_ingots"));
            if (oreTag != null) {
                this.ore(oreTag, (Supplier)ingot.get(), 0.125f, (Consumer<FinishedRecipe>)p);
            }
            if (nuggetTag != null) {
                ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)((RegistryEntry)ingot.get()).get())).m_126130_("###").m_126130_("###").m_126130_("###").m_206416_(Character.valueOf('#'), nuggetTag).m_142284_("has_at_least_9_" + this.safeName(this.getId(nuggetTag)), (CriterionTriggerInstance)DataIngredient.tag(nuggetTag).getCritereon((RegistrateRecipeProvider)p)).m_142700_((Consumer)p, this.rl(this.safeName(this.getId(nuggetTag)) + "_to_ingot"));
                ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)((RegistryEntry)Objects.requireNonNull(nugget).get()).get()), (int)9).m_206419_(ingotTag).m_142284_("has_ingot_" + this.safeName(this.getId(ingotTag)), (CriterionTriggerInstance)DataIngredient.tag(ingotTag).getCritereon((RegistrateRecipeProvider)p)).m_142700_((Consumer)p, this.rl(this.safeName(this.getId(ingotTag)) + "_to_9_nuggets"));
            }
            if (dustTag != null) {
                this.dust(dustTag, (Supplier)ingot.get(), 0.125f, (Consumer<FinishedRecipe>)p);
            }
        };
    }

    protected static InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... pPredicates) {
        return new InventoryChangeTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, pPredicates);
    }

    protected static InventoryChangeTrigger.TriggerInstance has(TagKey<Item> pTag) {
        return RecipeGenerator.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_204145_(pTag).m_45077_());
    }

    protected static InventoryChangeTrigger.TriggerInstance has(ItemLike pItemLike) {
        return RecipeGenerator.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{pItemLike}).m_45077_());
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void ore(TagKey<Item> source, Supplier<T> result, float xp, Consumer<FinishedRecipe> consumer) {
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_204132_(source), (ItemLike)((ItemLike)result.get()), (float)xp, (int)200).m_142284_("has_" + this.safeName(this.getId(source)), (CriterionTriggerInstance)RecipeGenerator.has(source)).m_142700_(consumer, this.rl(this.safeId((IForgeRegistryEntry)result.get()) + "_from_smelting"));
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_204132_(source), (ItemLike)((ItemLike)result.get()), (float)xp, (int)100).m_142284_("has_" + this.safeName(this.getId(source)), (CriterionTriggerInstance)RecipeGenerator.has(source)).m_142700_(consumer, this.rl(this.safeId((IForgeRegistryEntry)result.get()) + "_from_blasting"));
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void dust(TagKey<Item> source, Supplier<T> result, float xp, Consumer<FinishedRecipe> consumer) {
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_204132_(source), (ItemLike)((ItemLike)result.get()), (float)xp, (int)200).m_142284_("has_" + this.safeName(this.getId(source)), (CriterionTriggerInstance)RecipeGenerator.has(source)).m_142700_(consumer, this.rl(this.safeId((IForgeRegistryEntry)result.get()) + "_from_smelting_dust"));
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_204132_(source), (ItemLike)((ItemLike)result.get()), (float)xp, (int)100).m_142284_("has_" + this.safeName(this.getId(source)), (CriterionTriggerInstance)RecipeGenerator.has(source)).m_142700_(consumer, this.rl(this.safeId((IForgeRegistryEntry)result.get()) + "_from_blasting_dust"));
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void recycle(Supplier<? extends T> source, Supplier<? extends T> result, float xp, Consumer<FinishedRecipe> consumer) {
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get()), (float)xp, (int)200).m_142284_("has_" + this.safeName(((IForgeRegistryEntry)((ItemLike)source.get())).getRegistryName()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_smelting");
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get()), (float)xp, (int)100).m_142284_("has_" + this.safeName(((IForgeRegistryEntry)((ItemLike)source.get())).getRegistryName()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_blasting");
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void recycle(Supplier<? extends T> source, Supplier<? extends T> result, float xp, String namespace, Consumer<FinishedRecipe> consumer) {
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get()), (float)xp, (int)200).m_142284_("has_" + this.safeName(((IForgeRegistryEntry)((ItemLike)source.get())).getRegistryName()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_142700_(consumer, new ResourceLocation(namespace, this.safeName((IForgeRegistryEntry)result.get()) + "_from_smelting_" + this.safeName((IForgeRegistryEntry)source.get())));
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get()), (float)xp, (int)100).m_142284_("has_" + this.safeName(((IForgeRegistryEntry)((ItemLike)source.get())).getRegistryName()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_142700_(consumer, new ResourceLocation(namespace, this.safeName((IForgeRegistryEntry)result.get()) + "_from_blasting_" + this.safeName((IForgeRegistryEntry)source.get())));
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void recycle(TagKey<Item> tag, Supplier<? extends T> result, float xp, Consumer<FinishedRecipe> consumer) {
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_204132_(tag), (ItemLike)((ItemLike)result.get()), (float)xp, (int)200).m_142284_("has_" + this.safeName(((IForgeRegistryEntry)((ItemLike)result.get())).getRegistryName()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)result.get())).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_smelting");
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_204132_(tag), (ItemLike)((ItemLike)result.get()), (float)xp, (int)100).m_142284_("has_" + this.safeName(((IForgeRegistryEntry)((ItemLike)result.get())).getRegistryName()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)result.get())).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_blasting");
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void food(Supplier<? extends T> source, Supplier<? extends T> result, float xp, Consumer<FinishedRecipe> consumer) {
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get()), (float)xp, (int)200).m_142284_("has_" + this.safeName(((IForgeRegistryEntry)((ItemLike)source.get())).getRegistryName()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176498_(consumer);
        SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get()), (float)xp, (int)100, (SimpleCookingSerializer)RecipeSerializer.f_44093_).m_142284_("has_" + this.safeName(((IForgeRegistryEntry)((ItemLike)source.get())).getRegistryName()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_smoker");
        SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get()), (float)xp, (int)600, (SimpleCookingSerializer)RecipeSerializer.f_44094_).m_142284_("has_" + this.safeName(((IForgeRegistryEntry)((ItemLike)source.get())).getRegistryName()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_campfire");
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void food(TagKey<Item> source, Supplier<? extends T> result, float xp, Consumer<FinishedRecipe> consumer) {
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_204132_(source), (ItemLike)((ItemLike)result.get()), (float)xp, (int)200).m_142284_("has_" + this.safeName(this.getId(source)), (CriterionTriggerInstance)RecipeGenerator.has(source)).m_176498_(consumer);
        SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_204132_(source), (ItemLike)((ItemLike)result.get()), (float)xp, (int)100, (SimpleCookingSerializer)RecipeSerializer.f_44093_).m_142284_("has_" + this.safeName(this.getId(source)), (CriterionTriggerInstance)RecipeGenerator.has(source)).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_smoker");
        SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_204132_(source), (ItemLike)((ItemLike)result.get()), (float)xp, (int)600, (SimpleCookingSerializer)RecipeSerializer.f_44094_).m_142284_("has_" + this.safeName(this.getId(source)), (CriterionTriggerInstance)RecipeGenerator.has(source)).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_campfire");
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void smelting(Supplier<? extends T> source, Supplier<? extends T> result, float xp, boolean blast, Consumer<FinishedRecipe> consumer) {
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get()), (float)xp, (int)200).m_142284_("has_" + this.safeName(((IForgeRegistryEntry)((ItemLike)source.get())).getRegistryName()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_smelting");
        if (blast) {
            SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get()), (float)xp, (int)100).m_142284_("has_" + this.safeName(((IForgeRegistryEntry)((ItemLike)source.get())).getRegistryName()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_blasting");
        }
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void storage(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)output.get())).m_126130_("###").m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)input.get()).m_142284_("has_at_least_9_" + this.safeName((IForgeRegistryEntry)input.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)input.get())).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)input.get()), (int)9).m_126209_((ItemLike)output.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)output.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)output.get())).m_176500_(consumer, this.safeId((IForgeRegistryEntry)input.get()) + "_from_" + this.safeName((IForgeRegistryEntry)output.get()));
    }

    public Item getModElement(TagKey<Item> input) {
        Item last = Items.f_41852_;
        for (Holder hItem : Registry.f_122827_.m_206058_(input)) {
            Item item;
            last = item = (Item)hItem.m_203334_();
            if (!Objects.requireNonNull(item.getRegistryName()).m_135827_().equals(this.modid)) continue;
            return item;
        }
        return last;
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void storage(TagKey<Item> input, Supplier<? extends T> output, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)output.get())).m_126130_("###").m_126130_("###").m_126130_("###").m_206416_(Character.valueOf('#'), input).m_142284_("has_at_least_9_" + this.safeName(this.getId(input)), (CriterionTriggerInstance)RecipeGenerator.has(input)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126191_((ItemLike)this.getModElement(input), (int)9).m_126209_((ItemLike)output.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)output.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)output.get())).m_142700_(consumer, new ResourceLocation(this.modid, this.safeName(this.getId(input)) + "_from_" + this.safeName((IForgeRegistryEntry)output.get())));
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> ShapelessRecipeBuilder singleItemUnfinished(Supplier<? extends T> source, Supplier<? extends T> result, int required, int amount) {
        return ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)result.get()), (int)amount).m_126211_((ItemLike)source.get(), required).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get()));
    }

    public ResourceLocation safeId(ResourceLocation id) {
        return new ResourceLocation(id.m_135827_(), this.safeName(id));
    }

    public ResourceLocation safeId(IForgeRegistryEntry<?> registryEntry) {
        return this.safeId(registryEntry.getRegistryName());
    }

    public String safeName(ResourceLocation nameSource) {
        return nameSource.m_135815_().replace('/', '_');
    }

    public String safeName(IForgeRegistryEntry<?> registryEntry) {
        return this.safeName(registryEntry.getRegistryName());
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void dye(Supplier<? extends T> source, Supplier<? extends T> result, int required, int amount, Consumer<FinishedRecipe> consumer) {
        this.singleItemUnfinished(source, result, required, amount).m_142700_(consumer, new ResourceLocation(this.modid, Objects.requireNonNull(((IForgeRegistryEntry)((ItemLike)result.get())).getRegistryName()).m_135815_()));
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void singleItem(Supplier<? extends T> source, Supplier<? extends T> result, int required, int amount, Consumer<FinishedRecipe> consumer) {
        this.singleItemUnfinished(source, result, required, amount).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void planks(Supplier<? extends T> source, Supplier<? extends T> result, Consumer<FinishedRecipe> consumer) {
        this.singleItemUnfinished(source, result, 1, 4).m_142409_("planks").m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void twoByTwo(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, int count, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)count).m_126130_("XX").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)source.get()).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void twoByTwo(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        this.twoByTwo(source, result, group, 4, consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void stairs(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, boolean stone, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)4).m_126130_("X  ").m_126130_("XX ").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)source.get()).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176498_(consumer);
        if (stone) {
            SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get())).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName((IForgeRegistryEntry)source.get()) + "_stonecutting");
        }
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void slab(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, boolean stone, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)6).m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)source.get()).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176498_(consumer);
        if (stone) {
            SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get()), (int)2).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName((IForgeRegistryEntry)source.get()) + "_stonecutting");
        }
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void narrowPost(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, boolean stone, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)4).m_126130_("X").m_126130_("X").m_126127_(Character.valueOf('X'), (ItemLike)source.get()).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176498_(consumer);
        if (stone) {
            SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get()), (int)2).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName((IForgeRegistryEntry)source.get()) + "_stonecutting");
        }
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void widePost(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, boolean stone, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)6).m_126130_("X").m_126130_("X").m_126130_("X").m_126127_(Character.valueOf('X'), (ItemLike)source.get()).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176498_(consumer);
        if (stone) {
            SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get()), (int)2).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName((IForgeRegistryEntry)source.get()) + "_stonecutting");
        }
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void fence(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)3).m_126130_("W#W").m_126130_("W#W").m_126127_(Character.valueOf('W'), (ItemLike)source.get()).m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void fenceGate(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126130_("#W#").m_126130_("#W#").m_126127_(Character.valueOf('W'), (ItemLike)source.get()).m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void wall(Supplier<? extends T> source, Supplier<? extends T> result, boolean stone, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)6).m_126130_("XXX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)source.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176498_(consumer);
        if (stone) {
            SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get())).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName((IForgeRegistryEntry)source.get()) + "_stonecutting");
        }
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void door(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)3).m_126130_("XX").m_126130_("XX").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)source.get()).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void trapDoor(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)2).m_126130_("XXX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)source.get()).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)source.get())).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void axe(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("XX ").m_126130_("XS ").m_126130_(" S ").m_126127_(Character.valueOf('X'), (ItemLike)material.get()).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)material.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)material.get())).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void pickaxe(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("XXX").m_126130_(" S ").m_126130_(" S ").m_126127_(Character.valueOf('X'), (ItemLike)material.get()).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)material.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)material.get())).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void shovel(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("X").m_126130_("S").m_126130_("S").m_126127_(Character.valueOf('X'), (ItemLike)material.get()).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)material.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)material.get())).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void sword(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("X").m_126130_("X").m_126130_("S").m_126127_(Character.valueOf('X'), (ItemLike)material.get()).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)material.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)material.get())).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void knife(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_(" X").m_126130_("S ").m_126127_(Character.valueOf('X'), (ItemLike)material.get()).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)material.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)material.get())).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void knife(TagKey<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_(" X").m_126130_("S ").m_206416_(Character.valueOf('X'), material).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName(this.getId(material)), (CriterionTriggerInstance)RecipeGenerator.has(material)).m_176500_(consumer, this.safeName((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName(this.getId(material)));
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void hoe(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("XX ").m_126130_(" S ").m_126130_(" S ").m_126127_(Character.valueOf('X'), (ItemLike)material.get()).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)material.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)material.get())).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void boots(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("X X").m_126130_("X X").m_126127_(Character.valueOf('X'), (ItemLike)material.get()).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)material.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)material.get())).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void spear(Supplier<? extends Item> sword, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("X").m_126130_("S").m_126130_("S").m_126127_(Character.valueOf('X'), (ItemLike)sword.get()).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)sword.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)sword.get())).m_142700_(consumer, new ResourceLocation(this.modid, Objects.requireNonNull(((IForgeRegistryEntry)((ItemLike)result.get())).getRegistryName()).m_135815_()));
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void spear(Item sword, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("X").m_126130_("S").m_126130_("S").m_126127_(Character.valueOf('X'), (ItemLike)sword).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry<?>)sword), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)sword)).m_142700_(consumer, new ResourceLocation(this.modid, Objects.requireNonNull(((IForgeRegistryEntry)((ItemLike)result.get())).getRegistryName()).m_135815_()));
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void legs(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("XXX").m_126130_("X X").m_126130_("X X").m_126127_(Character.valueOf('X'), (ItemLike)material.get()).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)material.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)material.get())).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void chest(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("X X").m_126130_("XXX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)material.get()).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)material.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)material.get())).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void helmet(Supplier<? extends T> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("XXX").m_126130_("X X").m_126127_(Character.valueOf('X'), (ItemLike)material.get()).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)material.get()), (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)material.get())).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void axe(TagKey<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("XX ").m_126130_("XS ").m_126130_(" S ").m_206416_(Character.valueOf('X'), material).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName(this.getId(material)), (CriterionTriggerInstance)RecipeGenerator.has(material)).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void pickaxe(TagKey<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("XXX").m_126130_(" S ").m_126130_(" S ").m_206416_(Character.valueOf('X'), material).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName(this.getId(material)), (CriterionTriggerInstance)RecipeGenerator.has(material)).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void shovel(TagKey<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("X").m_126130_("S").m_126130_("S").m_206416_(Character.valueOf('X'), material).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName(this.getId(material)), (CriterionTriggerInstance)RecipeGenerator.has(material)).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void sword(TagKey<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("X").m_126130_("X").m_126130_("S").m_206416_(Character.valueOf('X'), material).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName(this.getId(material)), (CriterionTriggerInstance)RecipeGenerator.has(material)).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void hoe(TagKey<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("XX ").m_126130_(" S ").m_126130_(" S ").m_206416_(Character.valueOf('X'), material).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName(this.getId(material)), (CriterionTriggerInstance)RecipeGenerator.has(material)).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void boots(TagKey<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("X X").m_126130_("X X").m_206416_(Character.valueOf('X'), material).m_142409_(group).m_142284_("has_" + this.safeName(this.getId(material)), (CriterionTriggerInstance)RecipeGenerator.has(material)).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void legs(TagKey<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("XXX").m_126130_("X X").m_126130_("X X").m_206416_(Character.valueOf('X'), material).m_142409_(group).m_142284_("has_" + this.safeName(this.getId(material)), (CriterionTriggerInstance)RecipeGenerator.has(material)).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void chest(TagKey<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("X X").m_126130_("XXX").m_126130_("XXX").m_206416_(Character.valueOf('X'), material).m_142409_(group).m_142284_("has_" + this.safeName(this.getId(material)), (CriterionTriggerInstance)RecipeGenerator.has(material)).m_176498_(consumer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void helmet(TagKey<Item> material, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("XXX").m_126130_("X X").m_206416_(Character.valueOf('X'), material).m_142409_(group).m_142284_("has_" + this.safeName(this.getId(material)), (CriterionTriggerInstance)RecipeGenerator.has(material)).m_176498_(consumer);
    }

    public <T extends BaseItems.DrinkItem> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateRecipeProvider> cordial(Supplier<RegistryEntry<T>> cordial, ItemLike ingredient) {
        return this.cordial(cordial, () -> ingredient);
    }

    public <T extends BaseItems.DrinkItem> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateRecipeProvider> cordial(Supplier<RegistryEntry<T>> cordial, Supplier<? extends ItemLike> ingredient) {
        return this.cordial(cordial, ingredient, 4);
    }

    public <T extends BaseItems.DrinkItem> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateRecipeProvider> cordial(Supplier<RegistryEntry<T>> cordial, Supplier<? extends ItemLike> ingredient, int amount) {
        return (ctx, p) -> ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)((RegistryEntry)cordial.get()).get()), (int)amount).m_126130_("1S1").m_126130_("BWB").m_126130_("BSB").m_126127_(Character.valueOf('1'), (ItemLike)ingredient.get()).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42501_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42590_).m_126127_(Character.valueOf('W'), (ItemLike)Items.f_42447_).m_142284_("has_first", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)ingredient.get())).m_142284_("has_sugar", (CriterionTriggerInstance)RecipeGenerator.has((ItemLike)Items.f_42501_)).m_176498_((Consumer)p);
    }
}

