/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.repack.noobutil.data.generator;

import mysticmods.mysticalworld.repack.noobutil.item.WeaponType;
import mysticmods.mysticalworld.repack.noobutil.material.MaterialType;
import mysticmods.mysticalworld.repack.registrate.util.entry.RegistryEntry;
import mysticmods.mysticalworld.repack.registrate.util.nullness.NonNullFunction;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;

public class ItemGenerator {
    public static <T extends Item> NonNullFunction<Item.Properties, T> tool(ToolBuilder<T> builder, WeaponType matType, MaterialType material) {
        return b -> builder.apply(material.getItemMaterial(), material.getDamage(matType), material.getSpeed(matType), (Item.Properties)b);
    }

    public static <T extends Item> NonNullFunction<Item.Properties, T> sword(ToolBuilder<T> builder, MaterialType material) {
        return ItemGenerator.tool(builder, WeaponType.SWORD, material);
    }

    public static <T extends Item> NonNullFunction<Item.Properties, T> spear(ToolBuilder<T> builder, MaterialType material) {
        return ItemGenerator.tool(builder, WeaponType.SPEAR, material);
    }

    public static <T extends Item> NonNullFunction<Item.Properties, T> pickaxe(ToolBuilder<T> builder, MaterialType material) {
        return ItemGenerator.tool(builder, WeaponType.PICKAXE, material);
    }

    public static <T extends Item> NonNullFunction<Item.Properties, T> axe(ToolBuilder<T> builder, MaterialType material) {
        return ItemGenerator.tool(builder, WeaponType.AXE, material);
    }

    public static <T extends Item> NonNullFunction<Item.Properties, T> shovel(ToolBuilder<T> builder, MaterialType material) {
        return ItemGenerator.tool(builder, WeaponType.SHOVEL, material);
    }

    public static <T extends Item> NonNullFunction<Item.Properties, T> knife(ToolBuilder<T> builder, MaterialType material) {
        return ItemGenerator.tool(builder, WeaponType.KNIFE, material);
    }

    public static <T extends Item> NonNullFunction<Item.Properties, T> hoe(ToolBuilder<T> builder, MaterialType material) {
        return ItemGenerator.tool(builder, WeaponType.HOE, material);
    }

    public static <T extends ArmorItem> NonNullFunction<Item.Properties, T> armor(ArmorBuilder<T> builder, MaterialType material, EquipmentSlot slot) {
        return b -> (ArmorItem)builder.apply(material.getArmorMaterial(), slot, (Item.Properties)b);
    }

    public static NonNullFunction<Item.Properties, DyeItem> dyeItem(DyeColor color) {
        return b -> new DyeItem(color, b);
    }

    public static <T extends Block> NonNullFunction<Item.Properties, ItemNameBlockItem> blockNamedItem(RegistryEntry<T> block) {
        return b -> new ItemNameBlockItem((Block)block.get(), b);
    }

    @FunctionalInterface
    public static interface ToolBuilder<V extends Item> {
        public V apply(Tier var1, int var2, float var3, Item.Properties var4);
    }

    @FunctionalInterface
    public static interface ArmorBuilder<V extends Item> {
        public V apply(ArmorMaterial var1, EquipmentSlot var2, Item.Properties var3);
    }
}

