/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.repack.noobutil.data.generator;

import java.util.Objects;
import java.util.function.Supplier;
import mysticmods.mysticalworld.repack.noobutil.block.BaseBlocks;
import mysticmods.mysticalworld.repack.noobutil.reference.ModData;
import mysticmods.mysticalworld.repack.registrate.providers.DataGenContext;
import mysticmods.mysticalworld.repack.registrate.providers.RegistrateBlockstateProvider;
import mysticmods.mysticalworld.repack.registrate.util.entry.RegistryEntry;
import mysticmods.mysticalworld.repack.registrate.util.nullness.NonNullBiConsumer;
import mysticmods.mysticalworld.repack.registrate.util.nullness.NonNullSupplier;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockstateGenerator {
    private static <T extends IForgeRegistryEntry<?>> String name(T block) {
        return Objects.requireNonNull(block.getRegistryName()).m_135815_();
    }

    public static <T extends Block> void cropBlockstate(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider p) {
        String prefix = ctx.getName().replace("crop", "");
        ModelFile.ExistingModelFile crop = p.models().getExistingFile(new ResourceLocation("minecraft", "block/crop"));
        p.getVariantBuilder((Block)ctx.getEntry()).forAllStates(arg_0 -> BlockstateGenerator.lambda$cropBlockstate$0(prefix, p, (ModelFile)crop, arg_0));
    }

    public static <T extends Block> void crossBlockstate(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider p) {
        String prefix = ctx.getName().replace("crop", "");
        ModelFile.ExistingModelFile crop = p.models().getExistingFile(new ResourceLocation("minecraft", "block/cross"));
        p.getVariantBuilder((Block)ctx.getEntry()).forAllStates(arg_0 -> BlockstateGenerator.lambda$crossBlockstate$1(prefix, p, (ModelFile)crop, arg_0));
    }

    public static <T extends Block> void simpleBlockstate(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider p) {
        p.simpleBlock((Block)ctx.getEntry());
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> simpleBlockstate(ResourceLocation parent) {
        return (ctx, p) -> p.simpleBlock((Block)ctx.getEntry(), (ModelFile)p.models().getExistingFile(parent));
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> simpleBlockstate(String parent) {
        return BlockstateGenerator.simpleBlockstate(new ResourceLocation(ModData.getModid(), parent));
    }

    public static <T extends StairBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> stairs(RegistryEntry<? extends Block> parent) {
        return (ctx, p) -> p.stairsBlock((StairBlock)ctx.getEntry(), p.blockTexture((Block)parent.get()));
    }

    public static <T extends StairBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> stairs(Supplier<? extends Block> parent) {
        return (ctx, p) -> p.stairsBlock((StairBlock)ctx.getEntry(), p.blockTexture((Block)parent.get()));
    }

    public static <T extends SlabBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> slab(NonNullSupplier<? extends Block> parent, NonNullSupplier<Block> visual) {
        return (ctx, p) -> p.slabBlock((SlabBlock)ctx.getEntry(), p.blockTexture((Block)parent.get()), p.blockTexture((Block)visual.get()));
    }

    public static <T extends SlabBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> slab(NonNullSupplier<? extends Block> parent) {
        return (ctx, p) -> p.slabBlock((SlabBlock)ctx.getEntry(), p.blockTexture((Block)parent.get()), p.blockTexture((Block)parent.get()));
    }

    public static <T extends FenceBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> fence(NonNullSupplier<? extends Block> parent) {
        return (ctx, p) -> {
            p.fenceBlock((FenceBlock)ctx.getEntry(), p.blockTexture((Block)parent.get()));
            p.models().fenceInventory(BlockstateGenerator.name((FenceBlock)ctx.getEntry()) + "_inventory", p.blockTexture((Block)parent.get()));
        };
    }

    public static <T extends WallBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> wall(NonNullSupplier<? extends Block> parent) {
        return (ctx, p) -> {
            p.wallBlock((WallBlock)ctx.getEntry(), p.blockTexture((Block)parent.get()));
            p.models().wallInventory(BlockstateGenerator.name((WallBlock)ctx.getEntry()) + "_inventory", p.blockTexture((Block)parent.get()));
        };
    }

    public static <T extends FenceGateBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> gate(NonNullSupplier<? extends Block> parent) {
        return (ctx, p) -> p.fenceGateBlock((FenceGateBlock)ctx.getEntry(), p.blockTexture((Block)parent.get()));
    }

    public static <T extends BaseBlocks.WidePostBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> widePost(NonNullSupplier<? extends Block> parent) {
        return (ctx, p) -> p.getVariantBuilder((Block)ctx.getEntry()).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)p.models().getBuilder(BlockstateGenerator.name((BaseBlocks.WidePostBlock)((Object)((Object)ctx.getEntry()))))).parent((ModelFile)p.models().getExistingFile(new ResourceLocation(ModData.getModid(), "wide_post")))).texture("wall", p.blockTexture((Block)parent.get())))});
    }

    public static <T extends BaseBlocks.NarrowPostBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> narrowPost(NonNullSupplier<? extends Block> parent) {
        return (ctx, p) -> p.getVariantBuilder((Block)ctx.getEntry()).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)p.models().getBuilder(BlockstateGenerator.name((BaseBlocks.NarrowPostBlock)((Object)((Object)ctx.getEntry()))))).parent((ModelFile)p.models().getExistingFile(new ResourceLocation(ModData.getModid(), "narrow_post")))).texture("wall", p.blockTexture((Block)parent.get())))});
    }

    public static <T extends ButtonBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> button(NonNullSupplier<? extends Block> parent) {
        return (ctx, p) -> {
            ModelBuilder button = p.models().singleTexture(BlockstateGenerator.name((ButtonBlock)ctx.getEntry()), new ResourceLocation("minecraft", "block/button"), p.blockTexture((Block)parent.get()));
            ModelBuilder buttonPressed = p.models().singleTexture(BlockstateGenerator.name((ButtonBlock)ctx.getEntry()) + "_pressed", new ResourceLocation("minecraft", "block/button_pressed"), p.blockTexture((Block)parent.get()));
            p.models().singleTexture(BlockstateGenerator.name((ButtonBlock)ctx.getEntry()) + "_inventory", new ResourceLocation("minecraft", "block/button_inventory"), p.blockTexture((Block)parent.get()));
            p.getVariantBuilder((Block)ctx.getEntry()).forAllStates(arg_0 -> BlockstateGenerator.lambda$button$12((ModelFile)buttonPressed, (ModelFile)button, arg_0));
        };
    }

    public static <T extends BasePressurePlateBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> pressurePlate(NonNullSupplier<? extends Block> parent) {
        return (ctx, p) -> {
            ModelBuilder plate = p.models().singleTexture(BlockstateGenerator.name((BasePressurePlateBlock)ctx.getEntry()), new ResourceLocation("minecraft", "block/pressure_plate_up"), p.blockTexture((Block)parent.get()));
            ModelBuilder platePowered = p.models().singleTexture(BlockstateGenerator.name((BasePressurePlateBlock)ctx.getEntry()) + "_down", new ResourceLocation("minecraft", "block/pressure_plate_down"), p.blockTexture((Block)parent.get()));
            p.getVariantBuilder((Block)ctx.getEntry()).forAllStates(arg_0 -> BlockstateGenerator.lambda$pressurePlate$14((ModelFile)platePowered, (ModelFile)plate, arg_0));
        };
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> pillar(String sideName, String topName) {
        return (ctx, p) -> {
            ResourceLocation side = new ResourceLocation(ModData.getModid(), sideName);
            ResourceLocation top = new ResourceLocation(ModData.getModid(), topName);
            ModelBuilder pillar = p.models().cubeColumn(BlockstateGenerator.name((Block)ctx.getEntry()), side, top);
            p.getVariantBuilder((Block)ctx.getEntry()).forAllStates(arg_0 -> BlockstateGenerator.lambda$pillar$16((ModelFile)pillar, arg_0));
        };
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> existingNoRotation(String existingModel) {
        return (ctx, p) -> {
            ResourceLocation rl = p.modLoc(existingModel);
            ModelFile.ExistingModelFile existing = p.models().getExistingFile(rl);
            p.getVariantBuilder((Block)ctx.getEntry()).forAllStates(arg_0 -> BlockstateGenerator.lambda$existingNoRotation$18((ModelFile)existing, arg_0));
        };
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> existingRotation(String existingModel) {
        return (ctx, p) -> {
            ResourceLocation rl = p.modLoc(existingModel);
            ModelFile.ExistingModelFile existing = p.models().getExistingFile(rl);
            p.getVariantBuilder((Block)ctx.getEntry()).forAllStates(arg_0 -> BlockstateGenerator.lambda$existingRotation$20((ModelFile)existing, arg_0));
        };
    }

    private static /* synthetic */ ConfiguredModel[] lambda$existingRotation$20(ModelFile existing, BlockState state) {
        int xRot = 0;
        Direction dir = state.m_61138_((Property)BlockStateProperties.f_61374_) ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_) : (state.m_61138_((Property)BlockStateProperties.f_61372_) ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_) : Direction.EAST);
        return ConfiguredModel.builder().modelFile(existing).rotationX(xRot).rotationY(dir.m_122434_().m_122478_() ? 0 : (int)(dir.m_122435_() % 360.0f)).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$existingNoRotation$18(ModelFile existing, BlockState state) {
        return ConfiguredModel.builder().modelFile(existing).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$pillar$16(ModelFile pillar, BlockState state) {
        return ConfiguredModel.builder().modelFile(pillar).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$pressurePlate$14(ModelFile platePowered, ModelFile plate, BlockState state) {
        return ConfiguredModel.builder().modelFile((Boolean)state.m_61143_((Property)PressurePlateBlock.f_55249_) != false ? platePowered : plate).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$button$12(ModelFile buttonPressed, ModelFile button, BlockState state) {
        int x = 0;
        int y = 0;
        block0 : switch ((AttachFace)state.m_61143_((Property)ButtonBlock.f_53179_)) {
            case CEILING: {
                switch ((Direction)state.m_61143_((Property)ButtonBlock.f_54117_)) {
                    case EAST: {
                        y = 270;
                        x = 180;
                        break;
                    }
                    case NORTH: {
                        y = 180;
                        x = 180;
                        break;
                    }
                    case SOUTH: {
                        x = 180;
                        break;
                    }
                    case WEST: {
                        y = 90;
                        x = 180;
                    }
                }
                break;
            }
            case FLOOR: {
                switch ((Direction)state.m_61143_((Property)ButtonBlock.f_54117_)) {
                    case EAST: {
                        y = 90;
                        break;
                    }
                    case NORTH: {
                        break;
                    }
                    case SOUTH: {
                        y = 180;
                        break;
                    }
                    case WEST: {
                        y = 270;
                    }
                }
                break;
            }
            case WALL: {
                switch ((Direction)state.m_61143_((Property)ButtonBlock.f_54117_)) {
                    case EAST: {
                        y = 90;
                        x = 90;
                        break block0;
                    }
                    case NORTH: {
                        x = 90;
                        break block0;
                    }
                    case SOUTH: {
                        y = 180;
                        x = 90;
                        break block0;
                    }
                    case WEST: {
                        y = 270;
                        x = 90;
                    }
                }
            }
        }
        ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((Boolean)state.m_61143_((Property)ButtonBlock.f_51045_) != false ? buttonPressed : button);
        if (y != 0) {
            builder.rotationY(y);
        }
        if (x != 0) {
            builder.rotationX(x);
        }
        return builder.build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$crossBlockstate$1(String prefix, RegistrateBlockstateProvider p, ModelFile crop, BlockState state) {
        String file = prefix + state.m_61143_((Property)((CropBlock)state.m_60734_()).m_7959_());
        ModelBuilder stage = ((BlockModelBuilder)((BlockModelBuilder)p.models().getBuilder(file)).parent(crop)).texture("cross", p.modLoc("block/crops/" + file));
        return ConfiguredModel.builder().modelFile((ModelFile)stage).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$cropBlockstate$0(String prefix, RegistrateBlockstateProvider p, ModelFile crop, BlockState state) {
        String file = prefix + state.m_61143_((Property)((CropBlock)state.m_60734_()).m_7959_());
        ModelBuilder stage = ((BlockModelBuilder)((BlockModelBuilder)p.models().getBuilder(file)).parent(crop)).texture("crop", p.modLoc("block/crops/" + file));
        return ConfiguredModel.builder().modelFile((ModelFile)stage).build();
    }
}

