/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import mysticmods.mysticalworld.recipe.IDamageRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapelessDamageRecipe
extends ShapelessRecipe
implements IDamageRecipe {
    private final Ingredient damageItem;
    private final Ingredient damageIngredient;
    private final int damageAmount;

    public ShapelessDamageRecipe(ResourceLocation idIn, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn, Ingredient damageItem, int damageAmount) {
        super(idIn, groupIn, recipeOutputIn, recipeItemsIn);
        this.damageItem = damageItem;
        this.damageAmount = damageAmount;
        this.damageIngredient = this.createDamageIngredient(damageItem);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        return this.getRemainingItems(inv, this.damageIngredient, this.damageAmount);
    }

    public static ShapelessDamageRecipe create(ShapelessRecipe recipe, Ingredient damageItem, int damageAmount) {
        return new ShapelessDamageRecipe(recipe.m_6423_(), recipe.m_6076_(), recipe.m_8043_(), (NonNullList<Ingredient>)recipe.m_7527_(), damageItem, damageAmount);
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ShapelessDamageRecipe> {
        public ShapelessDamageRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapelessRecipe result = (ShapelessRecipe)RecipeSerializer.f_44077_.m_6729_(recipeId, json);
            Ingredient damageItem = Ingredient.m_43917_((JsonElement)json.get("damage_item"));
            int damageAmount = GsonHelper.m_13824_((JsonObject)json, (String)"damage_amount", (int)-1);
            if (damageAmount == -1) {
                throw new JsonSyntaxException("Invalid damage_amount for ShapelessDamageRecipe.");
            }
            return ShapelessDamageRecipe.create(result, damageItem, damageAmount);
        }

        public ShapelessDamageRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapelessRecipe result = (ShapelessRecipe)RecipeSerializer.f_44077_.m_8005_(recipeId, buffer);
            Ingredient damageItem = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int damageAmount = buffer.readInt();
            return ShapelessDamageRecipe.create(result, damageItem, damageAmount);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapelessDamageRecipe recipe) {
            RecipeSerializer.f_44077_.m_6178_(buffer, (Recipe)recipe);
            recipe.damageItem.m_43923_(buffer);
            buffer.writeInt(recipe.damageAmount);
        }
    }
}

