/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import mysticmods.mysticalworld.recipe.IDamageRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapedDamageRecipe
extends ShapedRecipe
implements IDamageRecipe {
    private final Ingredient damageItem;
    private final Ingredient damageIngredient;
    private final int damageAmount;

    private ShapedDamageRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn, Ingredient damageItem, int damageAmount) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
        this.damageItem = damageItem;
        this.damageAmount = damageAmount;
        this.damageIngredient = this.createDamageIngredient(damageItem);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        return this.getRemainingItems(inv, this.damageIngredient, this.damageAmount);
    }

    public static ShapedDamageRecipe create(ShapedRecipe recipe, Ingredient damageItem, int damageAmount) {
        return new ShapedDamageRecipe(recipe.m_6423_(), recipe.m_6076_(), recipe.getRecipeWidth(), recipe.getRecipeHeight(), (NonNullList<Ingredient>)recipe.m_7527_(), recipe.m_8043_(), damageItem, damageAmount);
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ShapedDamageRecipe> {
        public ShapedDamageRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe result = (ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(recipeId, json);
            Ingredient damageItem = Ingredient.m_43917_((JsonElement)json.get("damage_item"));
            int damageAmount = GsonHelper.m_13824_((JsonObject)json, (String)"damage_amount", (int)-1);
            if (damageAmount == -1) {
                throw new JsonSyntaxException("Invalid damage_amount for ShapedDamageRecipe.");
            }
            return ShapedDamageRecipe.create(result, damageItem, damageAmount);
        }

        public ShapedDamageRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapedRecipe result = (ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(recipeId, buffer);
            Ingredient damageItem = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int damageAmount = buffer.readInt();
            return ShapedDamageRecipe.create(result, damageItem, damageAmount);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedDamageRecipe recipe) {
            RecipeSerializer.f_44076_.m_6178_(buffer, (Recipe)recipe);
            recipe.damageItem.m_43923_(buffer);
            buffer.writeInt(recipe.damageAmount);
        }
    }
}

