/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.recipe;

import java.util.ArrayList;
import mysticmods.mysticalworld.repack.noobutil.ingredient.LazyIngredient;
import mysticmods.mysticalworld.repack.noobutil.util.MathUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public interface IDamageRecipe {
    public static final String TAG = "damage_item";
    public static final String DAMAGE = "damage_amount";

    default public LazyIngredient createDamageIngredient(Ingredient ingredient) {
        return new LazyIngredient(() -> {
            ArrayList<ItemStack> matchingStacks = new ArrayList<ItemStack>();
            for (ItemStack stack : ingredient.m_43908_()) {
                if (!stack.m_41763_()) {
                    throw new IllegalArgumentException("Invalid itemstack '" + stack + "' for DamageRecipe: flagged as damage item, but not damageable.");
                }
                for (int i = 0; i < stack.m_41776_(); ++i) {
                    ItemStack copy = stack.m_41777_();
                    copy.m_41721_(i);
                    matchingStacks.add(copy);
                }
            }
            return Ingredient.m_43927_((ItemStack[])matchingStacks.toArray(new ItemStack[0]));
        });
    }

    default public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv, Ingredient damageIngredient, int damageAmount) {
        NonNullList result = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < result.size(); ++i) {
            ItemStack current = inv.m_8020_(i);
            if (current.m_41619_() || !damageIngredient.test(current)) continue;
            if ((current = current.m_41777_()).m_41629_(damageAmount, MathUtil.rand, null)) {
                current.m_41764_(0);
            }
            if (current.m_41619_()) continue;
            result.set(i, (Object)current);
        }
        return result;
    }
}

