/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.recipe;

import mysticmods.mysticalworld.init.ModRecipes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BlazeRocketRecipe
extends CustomRecipe {
    private static final Ingredient INGREDIENT_PAPER = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42516_});
    private static final Ingredient INGREDIENT_BLAZE_POWDER = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42593_});
    private static final Ingredient INGREDIENT_FIREWORK_STAR = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42689_});

    public BlazeRocketRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        boolean flag = false;
        int i = 0;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            if (INGREDIENT_PAPER.test(itemstack)) {
                if (flag) {
                    return false;
                }
                flag = true;
                continue;
            }
            if (!(INGREDIENT_BLAZE_POWDER.test(itemstack) ? ++i > 3 : !INGREDIENT_FIREWORK_STAR.test(itemstack))) continue;
            return false;
        }
        return flag && i >= 1;
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42688_, 5);
        CompoundTag compoundnbt = itemstack.m_41698_("Fireworks");
        ListTag listnbt = new ListTag();
        int i = 0;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            CompoundTag compoundnbt1;
            ItemStack itemstack1 = inv.m_8020_(j);
            if (itemstack1.m_41619_()) continue;
            if (INGREDIENT_BLAZE_POWDER.test(itemstack1)) {
                ++i;
                continue;
            }
            if (!INGREDIENT_FIREWORK_STAR.test(itemstack1) || (compoundnbt1 = itemstack1.m_41737_("Explosion")) == null) continue;
            listnbt.add((Object)compoundnbt1);
        }
        compoundnbt.m_128344_("Flight", (byte)(i * 2));
        if (!listnbt.isEmpty()) {
            compoundnbt.m_128365_("Explosions", (Tag)listnbt);
        }
        return itemstack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)Items.f_42688_);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.BLAZE_SERIALIZER.get();
    }
}

