/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class AbstractCookingRecipeSerializer<T extends AbstractCookingRecipe>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<T> {
    protected final int defaultCookTime;
    protected final IFactory<T> serializer;

    public AbstractCookingRecipeSerializer(IFactory<T> serializer, int defaultCookTime) {
        this.defaultCookTime = defaultCookTime;
        this.serializer = serializer;
    }

    public T fromJson(ResourceLocation recipeId, JsonObject json) {
        ItemStack itemstack;
        String s = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonelement);
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get("result").isJsonObject()) {
            itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        } else {
            String s1 = GsonHelper.m_13906_((JsonObject)json, (String)"result");
            ResourceLocation resourcelocation = new ResourceLocation(s1);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(resourcelocation);
            if (item == null) {
                throw new IllegalStateException("Item: " + s1 + " does not exist");
            }
            itemstack = new ItemStack((ItemLike)item);
        }
        float f = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
        int i = GsonHelper.m_13824_((JsonObject)json, (String)"cookingtime", (int)this.defaultCookTime);
        return this.serializer.create(recipeId, s, ingredient, itemstack, f, i);
    }

    public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        String s = buffer.m_130136_(Short.MAX_VALUE);
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ItemStack itemstack = buffer.m_130267_();
        float f = buffer.readFloat();
        int i = buffer.m_130242_();
        return this.serializer.create(recipeId, s, ingredient, itemstack, f, i);
    }

    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        buffer.m_130070_(recipe.m_6076_());
        recipe.m_7527_().forEach(o -> o.m_43923_(buffer));
        buffer.m_130055_(recipe.m_8043_());
        buffer.writeFloat(recipe.m_43750_());
        buffer.m_130130_(recipe.m_43753_());
    }

    public static interface IFactory<T extends AbstractCookingRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4, float var5, int var6);
    }
}

