/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.network;

import java.util.UUID;
import java.util.function.Supplier;
import mysticmods.mysticalworld.MysticalWorld;
import mysticmods.mysticalworld.api.Capabilities;
import mysticmods.mysticalworld.api.IPlayerShoulderCapability;
import mysticmods.mysticalworld.capability.PlayerShoulderCapability;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ShoulderRide {
    private final CompoundTag tag;
    private final UUID id;

    public ShoulderRide(FriendlyByteBuf buffer) {
        long uuid1 = buffer.readLong();
        long uuid2 = buffer.readLong();
        this.id = new UUID(uuid1, uuid2);
        this.tag = buffer.m_130260_();
    }

    public ShoulderRide(Player player, IPlayerShoulderCapability cap) {
        this.tag = (CompoundTag)cap.serializeNBT();
        this.id = player.m_142081_();
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public UUID getId() {
        return this.id;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
        buf.m_130079_(this.tag);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ShoulderRide.handle(this, context));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handle(ShoulderRide message, Supplier<NetworkEvent.Context> context) {
        LocalPlayer target = Minecraft.m_91087_().f_91074_;
        if (target == null) {
            return;
        }
        Level world = target.f_19853_;
        if (!target.m_142081_().equals(message.getId())) {
            target = world.m_46003_(message.getId());
        }
        if (target == null) {
            return;
        }
        LocalPlayer player = target;
        target.getCapability(Capabilities.PLAYER_SHOULDER).ifPresent(arg_0 -> ShoulderRide.lambda$handle$1(message, (Player)player, arg_0));
        context.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$1(ShoulderRide message, Player player, IPlayerShoulderCapability cap) {
        cap.deserializeNBT((Tag)message.getTag());
        try {
            PlayerShoulderCapability.setLeftShoulder.invokeExact(player, cap.generateShoulderNBT());
        }
        catch (Throwable throwable) {
            MysticalWorld.LOG.error("Unable to fake player having a shoulder entity", throwable);
        }
    }
}

