/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import mysticmods.mysticalworld.MWTags;
import mysticmods.mysticalworld.init.ModLoot;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class RandomPotion
extends LootItemConditionalFunction {
    private RandomPotion(LootItemCondition[] conditions) {
        super(conditions);
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)ModLoot.RANDOM_POTION.get();
    }

    protected TagKey<Potion> getIgnoreTag() {
        return MWTags.Potions.RANDOM_BLACKLIST;
    }

    public ItemStack m_7372_(ItemStack stack, LootContext context) {
        Random random = context.m_78933_();
        HashSet blacklisted = new HashSet();
        Registry.f_122828_.m_206058_(this.getIgnoreTag()).forEach(o -> blacklisted.add((Potion)o.m_203334_()));
        List potions = ForgeRegistries.POTIONS.getValues().stream().filter(potion -> !blacklisted.contains(potion)).collect(Collectors.toList());
        Potion potion2 = (Potion)potions.get(random.nextInt(potions.size()));
        PotionUtils.m_43549_((ItemStack)stack, (Potion)potion2);
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return RandomPotion.m_80683_(RandomPotion::new);
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<RandomPotion> {
        public void serialize(JsonObject json, RandomPotion base, JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)base, context);
        }

        public RandomPotion deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditionsIn) {
            return new RandomPotion(conditionsIn);
        }
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        protected Builder getThis() {
            return this;
        }

        public Builder withEnchantment(Enchantment pEnchantment) {
            return this;
        }

        public LootItemFunction m_7453_() {
            return new RandomPotion(this.m_80699_());
        }
    }
}

