/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import mysticmods.mysticalworld.entity.SproutEntity;
import mysticmods.mysticalworld.init.ModLoot;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class IsColor
implements LootItemCondition {
    private final boolean inverse;
    private final int variant;

    public IsColor(boolean inverseIn, String color) {
        this.inverse = inverseIn;
        this.variant = SproutEntity.StringToVariant(color);
    }

    public boolean test(LootContext lootContext) {
        int variant;
        Entity looted = (Entity)lootContext.m_78953_(LootContextParams.f_81455_);
        if (looted instanceof SproutEntity) {
            SproutEntity sprout = (SproutEntity)looted;
            variant = (Integer)sprout.m_20088_().m_135370_(SproutEntity.variant);
        } else {
            variant = 0;
        }
        boolean flag = variant == this.variant;
        return flag == !this.inverse;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)ModLoot.IS_COLOR.get();
    }

    public static LootItemCondition.Builder builder(String variant) {
        return () -> new IsColor(false, variant);
    }

    public static class ColorSerializer
    implements Serializer<IsColor> {
        public void serialize(JsonObject json, IsColor value, JsonSerializationContext context) {
            json.addProperty("inverse", Boolean.valueOf(value.inverse));
            json.addProperty("color", SproutEntity.VariantToString(value.variant));
        }

        public IsColor deserialize(JsonObject json, JsonDeserializationContext context) {
            return new IsColor(GsonHelper.m_13855_((JsonObject)json, (String)"inverse", (boolean)false), GsonHelper.m_13851_((JsonObject)json, (String)"color", (String)"green"));
        }
    }
}

