/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.items;

import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mysticmods.mysticalworld.client.model.armor.ArmorModel;
import mysticmods.mysticalworld.config.ConfigManager;
import mysticmods.mysticalworld.init.ModMaterials;
import mysticmods.mysticalworld.items.ModifiedArmorItem;
import mysticmods.mysticalworld.repack.noobutil.material.MaterialType;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;

public class AntlerHatItem
extends ModifiedArmorItem {
    public AntlerHatItem(Item.Properties builder) {
        super(ModMaterials.ANTLER.getArmorMaterial(), EquipmentSlot.HEAD, builder);
    }

    @Override
    public Map<Attribute, AttributeModifier> getModifiers() {
        return super.getModifiers();
    }

    @Override
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        Multimap<Attribute, AttributeModifier> map = super.m_7167_(equipmentSlot);
        if (equipmentSlot == EquipmentSlot.HEAD && ConfigManager.HAT_CONFIG.getAntlerHealthBonus() != -1.0f) {
            map.put((Object)Attributes.f_22276_, (Object)this.getOrCreateModifier(Attributes.f_22276_, () -> new AttributeModifier(MaterialType.ARMOR_MODIFIERS[this.f_40377_.m_20749_()], "Antler Health Boost", (double)ConfigManager.HAT_CONFIG.getAntlerHealthBonus(), AttributeModifier.Operation.ADDITION)));
        }
        return map;
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (ConfigManager.HAT_CONFIG.getAntlerFrequency() == -1) {
            return;
        }
        if (!world.f_46443_) {
            float f = player.m_21223_();
            float f2 = ConfigManager.HAT_CONFIG.getAntlerThreshold() == -1 ? player.m_21233_() : player.m_21233_() - (float)ConfigManager.HAT_CONFIG.getAntlerThreshold();
            if (f < f2 && world.f_46441_.nextInt(ConfigManager.HAT_CONFIG.getAntlerFrequency()) == 0) {
                if (player.m_21124_(MobEffects.f_19605_) != null) {
                    return;
                }
                player.m_5634_(ConfigManager.HAT_CONFIG.getAntlerHealing());
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, ConfigManager.HAT_CONFIG.getAntlerRegenDuration(), ConfigManager.HAT_CONFIG.getAntlerRegenAmplifier()));
                ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
                if (ConfigManager.HAT_CONFIG.getAntlerDamage() != -1) {
                    head.m_41622_(ConfigManager.HAT_CONFIG.getAntlerDamage(), (LivingEntity)player, breaker -> breaker.m_21166_(EquipmentSlot.HEAD));
                }
            }
        }
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "mysticalworld:textures/models/armor/antler_hat.png";
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            @Nullable
            public HumanoidModel<?> getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
                return ArmorModel.getModel(itemStack);
            }
        });
    }
}

