/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.integration.patchouli.api;

import java.util.List;
import java.util.StringJoiner;
import mysticmods.mysticalworld.config.ConfigManager;
import mysticmods.mysticalworld.config.MobConfig;
import mysticmods.mysticalworld.integration.patchouli.api.StandardDrops;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class AnimalSpawnInfo
implements IComponentProcessor {
    private String animalName;
    private MobConfig animal;

    public void setup(IVariableProvider iVariableProvider) {
        String name;
        this.animalName = name = iVariableProvider.get("animal").asString();
        switch (name) {
            case "deer": {
                this.animal = ConfigManager.DEER_CONFIG;
                break;
            }
            case "frog": {
                this.animal = ConfigManager.FROG_CONFIG;
                break;
            }
            case "sprout": {
                this.animal = ConfigManager.SPROUT_CONFIG;
                break;
            }
            case "beetle": {
                this.animal = ConfigManager.BEETLE_CONFIG;
                break;
            }
            case "fox": {
                this.animal = ConfigManager.SILVER_FOX_CONFIG;
                break;
            }
            case "endermini": {
                this.animal = ConfigManager.ENDERMINI_CONFIG;
                break;
            }
            case "lava_cat": {
                this.animal = ConfigManager.LAVA_CAT_CONFIG;
                break;
            }
            case "owl": {
                this.animal = ConfigManager.OWL_CONFIG;
                break;
            }
            case "hell_sprout": {
                this.animal = ConfigManager.HELL_SPROUT_CONFIG;
                break;
            }
            case "duck": {
                this.animal = ConfigManager.DUCK_CONFIG;
                break;
            }
            case "clam": {
                this.animal = ConfigManager.CLAM_CONFIG;
                break;
            }
            default: {
                this.animal = null;
            }
        }
    }

    public IVariable process(String s) {
        if (this.animal == null && !this.animalName.equals("squid")) {
            return null;
        }
        if (s.startsWith("groupSize")) {
            if (this.animalName.equals("squid")) {
                return IVariable.wrap((String)"Standard group sizes.");
            }
            return IVariable.wrap((String)String.format("Groups of: %d-%d", this.animal.getMin(), this.animal.getMax()));
        }
        if (s.startsWith("biomes")) {
            if (this.animalName.equals("squid")) {
                return IVariable.wrap((String)"Default biomes.");
            }
            if (this.animalName.equals("endermini")) {
                return IVariable.wrap((String)"The End");
            }
            StringJoiner joiner = new StringJoiner(", ");
            for (BiomeDictionary.Type biomeName : this.animal.getBiomes()) {
                if (biomeName == null) continue;
                joiner.add(WordUtils.capitalize((String)biomeName.getName().toLowerCase()));
            }
            return IVariable.wrap((String)("Biomes tagged with: " + joiner));
        }
        if (s.startsWith("title")) {
            if (this.animalName.contains("_")) {
                return IVariable.wrap((String)WordUtils.capitalize((String)this.animalName.replace("_", " ")));
            }
            return IVariable.wrap((String)WordUtils.capitalize((String)this.animalName.toLowerCase()));
        }
        if (s.startsWith("item")) {
            List<ItemStack> drops = StandardDrops.getDrops(this.animalName);
            int index = Integer.parseInt(s.replace("item", "")) - 1;
            if (index < drops.size()) {
                return IVariable.from((Object)drops.get(index));
            }
            return IVariable.from((Object)ItemStack.f_41583_);
        }
        return null;
    }
}

