/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.init;

import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import mysticmods.mysticalworld.MWTags;
import mysticmods.mysticalworld.config.ConfigManager;
import mysticmods.mysticalworld.config.FeatureConfig;
import mysticmods.mysticalworld.init.ModBlocks;
import mysticmods.mysticalworld.init.ModEntities;
import mysticmods.mysticalworld.world.placement.DimensionPlacement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="mysticalworld")
public class ModFeatures {
    private static final DeferredRegister<ConfiguredFeature<?, ?>> FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"mysticalworld");
    private static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"mysticalworld");
    private static final DeferredRegister<PlacementModifierType<?>> PLACEMENT_MODIFIERS = DeferredRegister.create((ResourceKey)Registry.f_194569_, (String)"mysticalworld");
    public static final RegistryObject<PlacementModifierType<?>> DIMENSION_PLACEMENT = PLACEMENT_MODIFIERS.register("dimension_placement", () -> new DimensionPlacement.Type());
    private static final RegistryObject<ConfiguredFeature<?, ?>> CONFIGURED_CHARRED_TREE = FEATURES.register("charred_tree", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)ModBlocks.CHARRED_LOG.getDefaultState()), (TrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)Blocks.f_50016_.m_49966_()), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).m_68244_().m_68251_()));
    public static final RegistryObject<PlacedFeature> CHARRED_TREE = PLACED_FEATURES.register("charred_tree", () -> new PlacedFeature((Holder)CONFIGURED_CHARRED_TREE.getHolder().get(), List.of(PlacementUtils.m_195364_((int)0, (float)((float)ConfigManager.DEAD_TREE_CONFIG.getChance()), (int)1), PlacementUtils.f_195355_, SurfaceWaterDepthFilter.m_191950_((int)0), BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190399_((BlockState)Blocks.f_50746_.m_49966_(), (Vec3i)BlockPos.f_121853_)), BiomeFilter.m_191561_())));
    private static final RegistryObject<ConfiguredFeature<?, ?>> CONFIGURED_STONEPETAL = FEATURES.register("stonepetal", () -> new ConfiguredFeature(Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)ModBlocks.STONEPETAL.getDefaultState()))));
    private static final RegistryObject<PlacedFeature> STONEPETAL = PLACED_FEATURES.register("stonepetal", () -> new PlacedFeature((Holder)CONFIGURED_STONEPETAL.getHolder().get(), List.of(BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.m_190419_(), (BlockPredicate)BlockPredicate.m_190396_((Block)Blocks.f_50069_, (Vec3i)new BlockPos(0, -1, 0)))))));
    private static final RegistryObject<ConfiguredFeature<?, ?>> CONFIGURED_STONEPETAL_PATCH = FEATURES.register("stonepetal_patch", () -> new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(ConfigManager.STONEPETAL_CONFIG.getTries(), 7, 3, (Holder)STONEPETAL.getHolder().get())));
    public static final RegistryObject<PlacedFeature> STONEPETAL_PATCH = PLACED_FEATURES.register("stonepetal_patch", () -> new PlacedFeature((Holder)CONFIGURED_STONEPETAL_PATCH.getHolder().get(), List.of(CountPlacement.m_191628_((int)ConfigManager.STONEPETAL_CONFIG.getRepeats()), InSquarePlacement.m_191715_(), RarityFilter.m_191900_((int)3), PlacementUtils.f_195352_, BiomeFilter.m_191561_())));
    private static final RegistryObject<ConfiguredFeature<?, ?>> CONFIGURED_TIN_ORE = FEATURES.register("tin_ore", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)ModBlocks.TIN_ORE.getDefaultState()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)ModBlocks.DEEPSLATE_TIN_ORE.getDefaultState())), ConfigManager.TIN_ORE.getSize())));
    public static final RegistryObject<PlacedFeature> TIN_ORE = PLACED_FEATURES.register("tin_ore", () -> new PlacedFeature((Holder)CONFIGURED_TIN_ORE.getHolder().get(), List.of(CountPlacement.m_191628_((int)ConfigManager.TIN_ORE.getChance()), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_(), DimensionPlacement.of(ConfigManager.TIN_ORE.getDimensions()), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)ConfigManager.TIN_ORE.getMinY()), (VerticalAnchor)VerticalAnchor.m_158922_((int)ConfigManager.TIN_ORE.getMaxY())))));
    private static final RegistryObject<ConfiguredFeature<?, ?>> CONFIGURED_SILVER_ORE = FEATURES.register("silver_ore", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)ModBlocks.SILVER_ORE.getDefaultState()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)ModBlocks.DEEPSLATE_SILVER_ORE.getDefaultState())), ConfigManager.SILVER_ORE.getSize())));
    public static final RegistryObject<PlacedFeature> SILVER_ORE = PLACED_FEATURES.register("silver_ore", () -> new PlacedFeature((Holder)CONFIGURED_SILVER_ORE.getHolder().get(), List.of(CountPlacement.m_191628_((int)ConfigManager.SILVER_ORE.getChance()), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_(), DimensionPlacement.of(ConfigManager.SILVER_ORE.getDimensions()), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)ConfigManager.SILVER_ORE.getMinY()), (VerticalAnchor)VerticalAnchor.m_158922_((int)ConfigManager.SILVER_ORE.getMaxY())))));
    private static final RegistryObject<ConfiguredFeature<?, ?>> CONFIGURED_LEAD_ORE = FEATURES.register("lead_ore", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)ModBlocks.LEAD_ORE.getDefaultState()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)ModBlocks.DEEPSLATE_LEAD_ORE.getDefaultState())), ConfigManager.LEAD_ORE.getSize())));
    public static final RegistryObject<PlacedFeature> LEAD_ORE = PLACED_FEATURES.register("lead_ore", () -> new PlacedFeature((Holder)CONFIGURED_LEAD_ORE.getHolder().get(), List.of(CountPlacement.m_191628_((int)ConfigManager.LEAD_ORE.getChance()), InSquarePlacement.m_191715_(), DimensionPlacement.of(ConfigManager.LEAD_ORE.getDimensions()), BiomeFilter.m_191561_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)ConfigManager.LEAD_ORE.getMinY()), (VerticalAnchor)VerticalAnchor.m_158922_((int)ConfigManager.LEAD_ORE.getMaxY())))));
    private static final RegistryObject<ConfiguredFeature<?, ?>> CONFIGURED_SAPPHIRE_ORE = FEATURES.register("sapphire_ore", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)ModBlocks.SAPPHIRE_ORE.getDefaultState()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)ModBlocks.DEEPSLATE_SAPPHIRE_ORE.getDefaultState())), ConfigManager.SAPPHIRE_ORE.getSize())));
    public static final RegistryObject<PlacedFeature> SAPPHIRE_ORE = PLACED_FEATURES.register("sapphire_ore", () -> new PlacedFeature((Holder)CONFIGURED_SAPPHIRE_ORE.getHolder().get(), List.of(CountPlacement.m_191628_((int)ConfigManager.SAPPHIRE_ORE.getChance()), InSquarePlacement.m_191715_(), DimensionPlacement.of(ConfigManager.SAPPHIRE_ORE.getDimensions()), BiomeFilter.m_191561_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)ConfigManager.SAPPHIRE_ORE.getMinY()), (VerticalAnchor)VerticalAnchor.m_158922_((int)ConfigManager.SAPPHIRE_ORE.getMaxY())))));
    private static final RuleTest GRANITE_REPLACEMENT = new TagMatchTest(MWTags.Blocks.BASE_STONE_GRANITE);
    private static final RegistryObject<ConfiguredFeature<?, ?>> CONFIGURED_GRANITE_QUARTZ_ORE = FEATURES.register("granite_quartz_ore", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.m_161021_((RuleTest)GRANITE_REPLACEMENT, (BlockState)ModBlocks.GRANITE_QUARTZ_ORE.getDefaultState())), ConfigManager.GRANITE_QUARTZ_ORE.getSize())));
    public static final RegistryObject<PlacedFeature> GRANITE_QUARTZ_ORE = PLACED_FEATURES.register("granite_quartz_ore", () -> new PlacedFeature((Holder)CONFIGURED_GRANITE_QUARTZ_ORE.getHolder().get(), List.of(CountPlacement.m_191628_((int)ConfigManager.GRANITE_QUARTZ_ORE.getChance()), InSquarePlacement.m_191715_(), DimensionPlacement.of(ConfigManager.GRANITE_QUARTZ_ORE.getDimensions()), BiomeFilter.m_191561_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)ConfigManager.GRANITE_QUARTZ_ORE.getMinY()), (VerticalAnchor)VerticalAnchor.m_158922_((int)ConfigManager.GRANITE_QUARTZ_ORE.getMaxY())))));
    public static List<Holder<PlacedFeature>> ORE_FEATURES = null;

    public static void register(IEventBus bus) {
        FEATURES.register(bus);
        PLACED_FEATURES.register(bus);
        PLACEMENT_MODIFIERS.register(bus);
    }

    public static void load() {
    }

    private static void tryPlaceFeature(BiomeLoadingEvent event, Set<BiomeDictionary.Type> types, FeatureConfig<?> config, RegistryObject<PlacedFeature> feature) {
        for (BiomeDictionary.Type rest : config.getBiomeRestrictions()) {
            if (!types.contains(rest)) continue;
            return;
        }
        boolean place = false;
        if (config.getBiomes().isEmpty()) {
            place = true;
        } else {
            Set<BiomeDictionary.Type> biomeTypes = config.getBiomes();
            for (BiomeDictionary.Type poss : biomeTypes) {
                if (!types.contains(poss)) continue;
                place = true;
                break;
            }
        }
        if (!place) {
            return;
        }
        if (config.isFeature()) {
            event.getGeneration().getFeatures(config.getStage()).add((Holder)feature.getHolder().get());
        }
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        if (ORE_FEATURES == null) {
            ORE_FEATURES = new ArrayList<Holder<PlacedFeature>>();
            if (ConfigManager.TIN_ORE.shouldGenerate()) {
                ORE_FEATURES.add((Holder<PlacedFeature>)((Holder)TIN_ORE.getHolder().get()));
            }
            if (ConfigManager.SILVER_ORE.shouldGenerate()) {
                ORE_FEATURES.add((Holder<PlacedFeature>)((Holder)SILVER_ORE.getHolder().get()));
            }
            if (ConfigManager.LEAD_ORE.shouldGenerate()) {
                ORE_FEATURES.add((Holder<PlacedFeature>)((Holder)LEAD_ORE.getHolder().get()));
            }
            if (ConfigManager.SAPPHIRE_ORE.shouldGenerate()) {
                ORE_FEATURES.add((Holder<PlacedFeature>)((Holder)SAPPHIRE_ORE.getHolder().get()));
            }
            if (ConfigManager.GRANITE_QUARTZ_ORE.shouldGenerate()) {
                ORE_FEATURES.add((Holder<PlacedFeature>)((Holder)GRANITE_QUARTZ_ORE.getHolder().get()));
            }
        }
        event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES).addAll(ORE_FEATURES);
        if (event.getName() != null) {
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)event.getName());
            Set types = BiomeDictionary.getTypes((ResourceKey)key);
            ModEntities.registerEntity(event, types);
            if (!ModList.get().isLoaded("dynamictrees")) {
                ModFeatures.tryPlaceFeature(event, types, ConfigManager.DEAD_TREE_CONFIG, CHARRED_TREE);
            }
            ModFeatures.tryPlaceFeature(event, types, ConfigManager.STONEPETAL_CONFIG, STONEPETAL_PATCH);
        }
    }
}

