/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.init;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mysticmods.mysticalworld.MysticalWorld;
import mysticmods.mysticalworld.config.ConfigManager;
import mysticmods.mysticalworld.config.MobConfig;
import mysticmods.mysticalworld.entity.BeetleEntity;
import mysticmods.mysticalworld.entity.ClamEntity;
import mysticmods.mysticalworld.entity.DeerEntity;
import mysticmods.mysticalworld.entity.DuckEntity;
import mysticmods.mysticalworld.entity.EnderminiEntity;
import mysticmods.mysticalworld.entity.FrogEntity;
import mysticmods.mysticalworld.entity.HellSproutEntity;
import mysticmods.mysticalworld.entity.LavaCatEntity;
import mysticmods.mysticalworld.entity.OwlEntity;
import mysticmods.mysticalworld.entity.SilkwormEntity;
import mysticmods.mysticalworld.entity.SilverFoxEntity;
import mysticmods.mysticalworld.entity.SproutEntity;
import mysticmods.mysticalworld.init.ModItems;
import mysticmods.mysticalworld.loot.conditions.HasHorns;
import mysticmods.mysticalworld.loot.conditions.IsColor;
import mysticmods.mysticalworld.loot.conditions.IsEnder;
import mysticmods.mysticalworld.loot.conditions.IsLava;
import mysticmods.mysticalworld.loot.conditions.IsMature;
import mysticmods.mysticalworld.loot.conditions.IsObsidian;
import mysticmods.mysticalworld.repack.registrate.util.LazySpawnEggItem;
import mysticmods.mysticalworld.repack.registrate.util.entry.RegistryEntry;
import mysticmods.mysticalworld.repack.registrate.util.nullness.NonNullFunction;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mysticalworld", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static List<RegistryEntry<? extends LazySpawnEggItem<?>>> SPAWN_EGGS = new ArrayList();
    public static RegistryEntry<EntityType<BeetleEntity>> BEETLE = MysticalWorld.REGISTRATE.entity("beetle", BeetleEntity::new, MobCategory.CREATURE).properties(o -> o.m_20699_(0.75f, 0.75f).setTrackingRange(16).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).loot((p, e) -> p.m_124371_((EntityType<?>)e, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.CARAPACE.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42518_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)))).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))).register();
    public static RegistryEntry<EntityType<DeerEntity>> DEER = MysticalWorld.REGISTRATE.entity("deer", DeerEntity::new, MobCategory.CREATURE).loot((p, e) -> p.m_124371_((EntityType<?>)e, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f)))).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.VENISON.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_5577_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_6509_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_()))))).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79161_(LootPool.m_79043_().m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ANTLERS.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_6509_(HasHorns.builder())).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))).properties(o -> o.m_20699_(1.0f, 1.0f).setTrackingRange(16).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static RegistryEntry<EntityType<FrogEntity>> FROG = MysticalWorld.REGISTRATE.entity("frog", FrogEntity::new, MobCategory.AMBIENT).loot((p, e) -> p.m_124371_((EntityType<?>)e, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42518_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)))).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))).properties(o -> o.m_20699_(0.5f, 0.5f).setTrackingRange(16).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static RegistryEntry<EntityType<SilverFoxEntity>> SILVER_FOX = MysticalWorld.REGISTRATE.entity("silver_fox", SilverFoxEntity::new, MobCategory.CREATURE).loot((p, e) -> p.m_124371_((EntityType<?>)e, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.PELT.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)))).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))).properties(o -> o.m_20699_(0.75f, 0.75f).setTrackingRange(16).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static RegistryEntry<EntityType<HellSproutEntity>> HELL_SPROUT = MysticalWorld.REGISTRATE.entity("hell_sprout", HellSproutEntity::new, MobCategory.CREATURE).loot((p, e) -> p.m_124371_((EntityType<?>)e, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42588_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))).properties(o -> o.m_20699_(0.5f, 1.0f).setTrackingRange(16).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3).m_20719_()).register();
    public static RegistryEntry<EntityType<SproutEntity>> SPROUT = MysticalWorld.REGISTRATE.entity("sprout", SproutEntity::new, MobCategory.CREATURE).loot((p, e) -> p.m_124371_((EntityType<?>)e, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42575_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_6509_(IsColor.builder("green")).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.AUBERGINE.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_5577_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_6509_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_()))))).m_6509_(IsColor.builder("purple")).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42732_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_5577_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_6509_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_()))))).m_6509_(IsColor.builder("red")).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42620_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_5577_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_6509_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_()))))).m_6509_(IsColor.builder("tan")).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))).properties(o -> o.m_20699_(0.5f, 1.0f).setTrackingRange(16).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static RegistryEntry<EntityType<EnderminiEntity>> ENDERMINI = MysticalWorld.REGISTRATE.entity("endermini", EnderminiEntity::new, MobCategory.MONSTER).loot((p, e) -> p.m_124371_((EntityType<?>)e, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.YOUNG_PEARL.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f)))).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))).properties(o -> o.m_20699_(0.3f, 1.45f).setTrackingRange(32).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static RegistryEntry<EntityType<LavaCatEntity>> LAVA_CAT = MysticalWorld.REGISTRATE.entity("lava_cat", LavaCatEntity::new, MobCategory.CREATURE).loot((p, e) -> p.m_124371_((EntityType<?>)e, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_(((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41999_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_6509_(IsObsidian.builder())).m_6509_(LootItemRandomChanceCondition.m_81927_((float)0.7f))).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42594_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_6509_(IsObsidian.builder())).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42594_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_6509_(IsLava.builder())).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))).properties(o -> o.m_20699_(0.75f, 0.875f).setTrackingRange(34).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static RegistryEntry<EntityType<OwlEntity>> OWL = MysticalWorld.REGISTRATE.entity("owl", OwlEntity::new, MobCategory.CREATURE).loot((p, e) -> p.m_124371_((EntityType<?>)e, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42402_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))).properties(o -> o.m_20699_(0.5f, 0.9f).setTrackingRange(16).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static RegistryEntry<EntityType<SilkwormEntity>> SILKWORM = MysticalWorld.REGISTRATE.entity("silkworm", SilkwormEntity::new, MobCategory.CREATURE).loot((p, e) -> p.m_124371_((EntityType<?>)e, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.SILKWORM_EGG.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f)))).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))).properties(o -> o.m_20699_(0.8f, 0.6f).setTrackingRange(5).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static RegistryEntry<EntityType<DuckEntity>> DUCK = MysticalWorld.REGISTRATE.entity("duck", DuckEntity::new, MobCategory.CREATURE).loot((p, e) -> p.m_124371_((EntityType<?>)e, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42402_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))).properties(o -> o.m_20699_(0.5f, 0.9f).setTrackingRange(16).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static RegistryEntry<EntityType<ClamEntity>> CLAM = MysticalWorld.REGISTRATE.entity("clam", ClamEntity::new, MobCategory.WATER_CREATURE).loot((p, e) -> p.m_124371_((EntityType<?>)e, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_(((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42584_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_6509_(IsMature.builder())).m_6509_(IsEnder.builder())).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79161_(LootPool.m_79043_().m_79076_(((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.PEARL_GEM.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_6509_(IsMature.builder())).m_6509_(IsEnder.builder().m_81807_())).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))).properties(o -> o.m_20699_(0.75f, 0.75f).setTrackingRange(16).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static BiMap<RegistryEntry<? extends EntityType<?>>, MobConfig> configMap = HashBiMap.create();

    private static <E extends Entity> NonNullFunction<Item.Properties, LazySpawnEggItem<E>> spawnEgg(RegistryEntry<EntityType<E>> entity, int color1, int color2) {
        return properties -> new LazySpawnEggItem(entity, color1, color2, (Item.Properties)properties);
    }

    public static void registerEntity(BiomeLoadingEvent event, Set<BiomeDictionary.Type> types) {
        for (Map.Entry entry : configMap.entrySet()) {
            MobConfig conf = (MobConfig)entry.getValue();
            if (!conf.shouldRegister()) continue;
            HashSet<BiomeDictionary.Type> types2 = new HashSet<BiomeDictionary.Type>(types);
            types2.retainAll(conf.getBiomes());
            if (types2.isEmpty()) continue;
            if (conf.getRestriction() == BiomeDictionary.Type.NETHER && event.getCategory() == Biome.BiomeCategory.NETHER) {
                event.getSpawns().getSpawner(conf.getClassification()).add(new MobSpawnSettings.SpawnerData((EntityType)((RegistryEntry)entry.getKey()).get(), conf.getChance(), conf.getMin(), conf.getMax()));
                continue;
            }
            if (conf.getRestriction() == BiomeDictionary.Type.OVERWORLD && event.getCategory() != Biome.BiomeCategory.NETHER && event.getCategory() != Biome.BiomeCategory.THEEND) {
                event.getSpawns().getSpawner(conf.getClassification()).add(new MobSpawnSettings.SpawnerData((EntityType)((RegistryEntry)entry.getKey()).get(), conf.getChance(), conf.getMin(), conf.getMax()));
                continue;
            }
            if (conf.getRestriction() != BiomeDictionary.Type.END || event.getCategory() != Biome.BiomeCategory.THEEND) continue;
            event.getSpawns().getSpawner(conf.getClassification()).add(new MobSpawnSettings.SpawnerData((EntityType)((RegistryEntry)entry.getKey()).get(), conf.getChance(), conf.getMin(), conf.getMax()));
        }
        if (event.getName() != null && event.getName().m_135827_().equals("mysticalbiomes") && event.getName().m_135815_().contains("sprout")) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData(SPROUT.get(), 18, 2, 8));
        }
    }

    public static void registerEntities() {
        SpawnPlacements.m_21754_(DEER.get(), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
        SpawnPlacements.m_21754_(FROG.get(), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
        SpawnPlacements.m_21754_(SPROUT.get(), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
        SpawnPlacements.m_21754_(SILVER_FOX.get(), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
        SpawnPlacements.m_21754_(BEETLE.get(), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
        SpawnPlacements.m_21754_(OWL.get(), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, OwlEntity::placement);
        SpawnPlacements.m_21754_(LAVA_CAT.get(), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, LavaCatEntity::placement);
        SpawnPlacements.m_21754_(HELL_SPROUT.get(), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, LavaCatEntity::placement);
        SpawnPlacements.m_21754_(ENDERMINI.get(), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EnderminiEntity::checkMonsterSpawnRules);
        SpawnPlacements.m_21754_(DUCK.get(), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
        SpawnPlacements.m_21754_(CLAM.get(), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ClamEntity::checkClamSpawnRules);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put(BEETLE.get(), BeetleEntity.attributes().m_22265_());
        event.put(DEER.get(), DeerEntity.attributes().m_22265_());
        event.put(FROG.get(), FrogEntity.attributes().m_22265_());
        event.put(SILVER_FOX.get(), SilverFoxEntity.attributes().m_22265_());
        event.put(SPROUT.get(), SproutEntity.attributes().m_22265_());
        event.put(ENDERMINI.get(), EnderminiEntity.attributes().m_22265_());
        event.put(LAVA_CAT.get(), LavaCatEntity.attributes().m_22265_());
        event.put(OWL.get(), OwlEntity.attributes().m_22265_());
        event.put(SILKWORM.get(), SilkwormEntity.attributes().m_22265_());
        event.put(HELL_SPROUT.get(), HellSproutEntity.attributes().m_22265_());
        event.put(DUCK.get(), DuckEntity.attributes().m_22265_());
        event.put(CLAM.get(), ClamEntity.attributes().m_22265_());
    }

    public static void load() {
    }

    static {
        configMap.put(BEETLE, (Object)ConfigManager.BEETLE_CONFIG);
        configMap.put(DEER, (Object)ConfigManager.DEER_CONFIG);
        configMap.put(FROG, (Object)ConfigManager.FROG_CONFIG);
        configMap.put(SILVER_FOX, (Object)ConfigManager.SILVER_FOX_CONFIG);
        configMap.put(SPROUT, (Object)ConfigManager.SPROUT_CONFIG);
        configMap.put(ENDERMINI, (Object)ConfigManager.ENDERMINI_CONFIG);
        configMap.put(LAVA_CAT, (Object)ConfigManager.LAVA_CAT_CONFIG);
        configMap.put(OWL, (Object)ConfigManager.OWL_CONFIG);
        configMap.put(HELL_SPROUT, (Object)ConfigManager.HELL_SPROUT_CONFIG);
        configMap.put(DUCK, (Object)ConfigManager.DUCK_CONFIG);
        configMap.put(CLAM, (Object)ConfigManager.CLAM_CONFIG);
    }
}

