/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.events.forge.mappings;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mysticmods.mysticalworld.MysticalWorld;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="mysticalworld")
public class Remaps {
    public static ResourceLocation IGNORE = new ResourceLocation("mysticalworld", "ignore_remap");
    public static Map<ResourceLocation, ResourceLocation> remappedItems = new HashMap<ResourceLocation, ResourceLocation>();
    public static Map<ResourceLocation, ResourceLocation> remappedBlocks = new HashMap<ResourceLocation, ResourceLocation>();
    public static Map<ResourceLocation, ResourceLocation> remappedEntities = new HashMap<ResourceLocation, ResourceLocation>();

    private static void ignore(String oldName, RemapType type) {
        Remaps.remap(oldName, "ignore_remap", type);
    }

    public static void remapItem(String o, String n) {
        Remaps.remap(o, n, RemapType.ITEM);
    }

    public static void remapBlock(String o, String n) {
        Remaps.remap(o, n, RemapType.BLOCK);
    }

    public static void remapEntity(String o, String n) {
        Remaps.remap(o, n, RemapType.ENTITY);
    }

    private static void remap(String oldName, String newName, RemapType type) {
        Map<ResourceLocation, ResourceLocation> remapper = type.getMap().get();
        String mapType = type.getName();
        ResourceLocation oldRL = new ResourceLocation("mysticalworld", oldName);
        ResourceLocation newRL = new ResourceLocation("mysticalworld", newName);
        if (remapper.containsKey(oldRL)) {
            MysticalWorld.LOG.error("Invalid " + mapType + " remap: " + oldRL + " already exists and remaps to " + remapper.get(oldRL).toString() + ", cannot also remap to " + newRL, (Throwable)new IllegalStateException("Duplicate " + mapType + " remap"));
        }
        remapper.put(oldRL, newRL);
    }

    @SubscribeEvent
    public static void remapItemEvent(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            ResourceLocation remap = remappedItems.get(mapping.key);
            if (remap != null && remap.equals((Object)IGNORE)) {
                mapping.ignore();
                continue;
            }
            if (remap == null) continue;
            Item remapped = (Item)ForgeRegistries.ITEMS.getValue(remap);
            if (remapped == null || remapped == Items.f_41852_) {
                MysticalWorld.LOG.error("Attempted remapping is invalid: " + mapping.key + " is remapped to " + remap + " but that item doesn't exist!");
                continue;
            }
            mapping.remap((IForgeRegistryEntry)remapped);
            MysticalWorld.LOG.info("Remapped item: " + mapping.key + " to " + remap);
        }
    }

    @SubscribeEvent
    public static void remapBlockEvent(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            ResourceLocation remap = remappedBlocks.get(mapping.key);
            if (remap != null && remap.equals((Object)IGNORE)) {
                mapping.ignore();
                continue;
            }
            if (remap == null) continue;
            Block remapped = (Block)ForgeRegistries.BLOCKS.getValue(remap);
            if (remapped == null || remapped == Blocks.f_50016_) {
                MysticalWorld.LOG.error("Attempted remapping is invalid: " + mapping.key + " is remapped to " + remap + " but that block doesn't exist!");
                continue;
            }
            mapping.remap((IForgeRegistryEntry)remapped);
            MysticalWorld.LOG.info("Remapped block: " + mapping.key + " to " + remap);
        }
    }

    @SubscribeEvent
    public static void remapEntityEvent(RegistryEvent.MissingMappings<EntityType<?>> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            ResourceLocation remap = remappedEntities.get(mapping.key);
            if (remap != null && remap.equals((Object)IGNORE)) {
                mapping.ignore();
                continue;
            }
            if (remap == null) continue;
            EntityType remapped = (EntityType)ForgeRegistries.ENTITIES.getValue(remap);
            if (remapped == null) {
                MysticalWorld.LOG.error("Attempted remapping is invalid: " + mapping.key + " is remapped to " + remap + " but that entity doesn't exist!");
                continue;
            }
            mapping.remap((IForgeRegistryEntry)remapped);
            MysticalWorld.LOG.info("Remapped entity: " + mapping.key + " to " + remap);
        }
    }

    public static enum RemapType {
        ITEM("item", () -> remappedItems),
        BLOCK("block", () -> remappedBlocks),
        ENTITY("entity", () -> remappedEntities);

        private final String name;
        private final Supplier<Map<ResourceLocation, ResourceLocation>> map;

        public String getName() {
            return this.name;
        }

        public Supplier<Map<ResourceLocation, ResourceLocation>> getMap() {
            return this.map;
        }

        private RemapType(String name, Supplier<Map<ResourceLocation, ResourceLocation>> map) {
            this.name = name;
            this.map = map;
        }
    }
}

