/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.events.forge;

import mysticmods.mysticalworld.MysticalWorld;
import mysticmods.mysticalworld.api.Capabilities;
import mysticmods.mysticalworld.api.IPlayerShoulderCapability;
import mysticmods.mysticalworld.capability.PlayerShoulderCapability;
import mysticmods.mysticalworld.network.Networking;
import mysticmods.mysticalworld.network.ShoulderRide;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="mysticalworld")
public class ShoulderHandler {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getPlayer();
        Level world = event.getWorld();
        if (!world.m_46859_(event.getPos().m_7494_())) {
            return;
        }
        if (!world.m_5776_() && event.getHand() == InteractionHand.MAIN_HAND && player.m_6047_() && player.m_21205_().m_41619_()) {
            player.getCapability(Capabilities.PLAYER_SHOULDER).ifPresent(cap -> {
                Entity animal;
                EntityType<?> type;
                if (cap.isShouldered() && (type = cap.getEntityType()) != null && (animal = type.m_20615_(world)) != null) {
                    animal.m_20258_(cap.getAnimalSerialized());
                    BlockPos pos = event.getPos();
                    animal.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5);
                    world.m_7967_(animal);
                    player.m_6674_(InteractionHand.MAIN_HAND);
                    cap.drop();
                    try {
                        PlayerShoulderCapability.setLeftShoulder.invokeExact(player, new CompoundTag());
                    }
                    catch (Throwable throwable) {
                        MysticalWorld.LOG.error("Unable to unset player having a shoulder entity", throwable);
                    }
                    event.setCanceled(true);
                    ShoulderRide message = new ShoulderRide(player, (IPlayerShoulderCapability)cap);
                    Networking.send(PacketDistributor.ALL.noArg(), message);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (living instanceof Player) {
            Entity animal;
            EntityType<?> type;
            IPlayerShoulderCapability cap;
            Player player = (Player)living;
            Level world = player.f_19853_;
            LazyOptional laycap = player.getCapability(Capabilities.PLAYER_SHOULDER, null);
            if (laycap.isPresent() && (cap = (IPlayerShoulderCapability)laycap.orElseThrow(IllegalStateException::new)).isShouldered() && (type = cap.getEntityType()) != null && (animal = type.m_20615_(world)) != null) {
                animal.m_20258_(cap.getAnimalSerialized());
                Vec3 pos = player.m_20182_();
                animal.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                world.m_7967_(animal);
                player.m_6674_(InteractionHand.MAIN_HAND);
                cap.drop();
                try {
                    PlayerShoulderCapability.setLeftShoulder.invokeExact(player, new CompoundTag());
                }
                catch (Throwable throwable) {
                    MysticalWorld.LOG.error("Unable to unset player having a shoulder entity", throwable);
                }
                event.setCanceled(true);
                ShoulderRide message = new ShoulderRide(player, cap);
                Networking.send(PacketDistributor.ALL.noArg(), message);
            }
        }
    }
}

