/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.events.forge;

import com.google.common.collect.Sets;
import java.util.Set;
import mysticmods.mysticalworld.init.ModModifiers;
import mysticmods.mysticalworld.loot.Serendipity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mysticalworld")
public class LootHandler {
    private static final Set<ResourceLocation> tables = Sets.newHashSet((Object[])new ResourceLocation[]{BuiltInLootTables.f_78742_, BuiltInLootTables.f_78759_, BuiltInLootTables.f_78764_, BuiltInLootTables.f_78686_, BuiltInLootTables.f_78689_});
    private static final ResourceLocation squid_table = new ResourceLocation("minecraft", "entities/squid");

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent event) {
        if (tables.contains(event.getName())) {
            event.getTable().addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("mysticalworld", "chests/inject")).m_79707_(1).m_79711_(0)).name("mystical_world_chest_injection").m_79082_());
        }
        if (event.getName().equals((Object)squid_table)) {
            event.getTable().addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("mysticalworld", "entities/squid_inject"))).name("mystical_world_squid_injection").m_79082_());
        }
    }

    @SubscribeEvent
    public static void onLooting(LootingLevelEvent event) {
        Entity entity;
        DamageSource source = event.getDamageSource();
        if (source != null && (entity = source.m_7639_()) instanceof Player) {
            Player player = (Player)entity;
            event.setLootingLevel(event.getLootingLevel() + Serendipity.calculateAdditional(player.m_21133_(ModModifiers.SERENDIPITY.get())));
        }
    }
}

