/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.events.forge;

import mysticmods.mysticalworld.MWTags;
import mysticmods.mysticalworld.MysticalWorld;
import mysticmods.mysticalworld.api.Capabilities;
import mysticmods.mysticalworld.api.IPlayerShoulderCapability;
import mysticmods.mysticalworld.capability.AnimalCooldownCapability;
import mysticmods.mysticalworld.capability.PlayerShoulderCapability;
import mysticmods.mysticalworld.init.ModItems;
import mysticmods.mysticalworld.init.ModSounds;
import mysticmods.mysticalworld.network.Networking;
import mysticmods.mysticalworld.network.ShoulderRide;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="mysticalworld")
public class CapabilityHandler {
    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        if (player.m_36332_().m_128425_("id", 8) && player.m_36332_().m_128461_("id").equals("mysticalworld:beetle")) {
            try {
                PlayerShoulderCapability.setRightShoulder.invokeExact((Player)player, new CompoundTag());
            }
            catch (Throwable e) {
                MysticalWorld.LOG.error("Unable to clear " + player + "'s right shoulder! Oh dear.", e);
            }
        }
        player.getCapability(Capabilities.PLAYER_SHOULDER).ifPresent(cap -> {
            if (cap.isShouldered()) {
                ShoulderRide message = new ShoulderRide(event.getPlayer(), (IPlayerShoulderCapability)cap);
                Networking.send(PacketDistributor.ALL.noArg(), message);
                try {
                    PlayerShoulderCapability.setLeftShoulder.invokeExact((Player)player, cap.generateShoulderNBT());
                }
                catch (Throwable throwable) {
                    MysticalWorld.LOG.error("Unable to fake player having a shoulder entity", throwable);
                }
            }
        });
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        for (ServerPlayer other : server.m_6846_().m_11314_()) {
            other.getCapability(Capabilities.PLAYER_SHOULDER).ifPresent(cap -> {
                if (cap.isShouldered()) {
                    ShoulderRide message = new ShoulderRide(event.getPlayer(), (IPlayerShoulderCapability)cap);
                    Networking.sendTo(message, player);
                    try {
                        PlayerShoulderCapability.setLeftShoulder.invokeExact((Player)other, cap.generateShoulderNBT());
                    }
                    catch (Throwable throwable) {
                        MysticalWorld.LOG.error("Unable to fake player having a shoulder entity", throwable);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (((Entity)event.getObject()).m_6095_() == EntityType.f_20480_ || ((Entity)event.getObject()).m_6095_() == EntityType.f_147034_) {
            event.addCapability(Capabilities.ANIMAL_COOLDOWN_ID, (ICapabilityProvider)new AnimalCooldownCapability());
        } else if (((Entity)event.getObject()).m_6095_() == EntityType.f_20532_) {
            event.addCapability(Capabilities.PLAYER_SHOULDER_ID, (ICapabilityProvider)new PlayerShoulderCapability());
        }
    }

    @SubscribeEvent
    public static void onSquidMilked(PlayerInteractEvent.EntityInteract event) {
        Player player = (Player)event.getEntity();
        ItemStack heldItem = player.m_21120_(event.getHand());
        if (heldItem.m_204117_(MWTags.Items.BOTTLES) && (event.getTarget().m_6095_() == EntityType.f_20480_ || event.getTarget().m_6095_() == EntityType.f_147034_)) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            if (!event.getWorld().f_46443_) {
                event.getTarget().getCapability(Capabilities.ANIMAL_COOLDOWN).ifPresent(cap -> {
                    if (cap.hasExpired()) {
                        cap.setCooldown(300);
                        event.getWorld().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.SQUID_MILK.get(), SoundSource.PLAYERS, 0.5f, event.getWorld().f_46441_.nextFloat() * 0.25f + 0.6f, true);
                        if (!player.m_7500_()) {
                            heldItem.m_41774_(1);
                        }
                        player.m_150109_().m_36054_(new ItemStack((ItemLike)ModItems.INK_BOTTLE.get()));
                    } else {
                        player.m_5661_((Component)new TranslatableComponent("message.squid.cooldown").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)).m_131136_(Boolean.valueOf(true))), true);
                    }
                });
            }
        }
    }
}

