/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.entity.ai;

import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;

public class StalkGoal
extends Goal {
    private final Level world;
    protected PathfinderMob attacker;
    protected int attackTick;
    private final double speedTowardsTarget;
    private final boolean longMemory;
    private Path path;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    protected final int attackInterval = 20;
    private int failedPathFindingPenalty = 0;
    private final boolean canPenalize = false;

    public StalkGoal(PathfinderMob creature, double speedIn, boolean useLongMemory) {
        this.attacker = creature;
        this.world = creature.f_19853_;
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        EnumSet set = this.m_7684_();
        set.add(Goal.Flag.TARGET);
        this.m_7021_(set);
    }

    public boolean m_8036_() {
        LivingEntity entitylivingbase = this.attacker.m_5448_();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.m_6084_()) {
            return false;
        }
        this.path = this.attacker.m_21573_().m_6570_((Entity)entitylivingbase, 32);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(entitylivingbase) >= this.attacker.m_20275_(entitylivingbase.m_20185_(), entitylivingbase.m_142469_().f_82289_, entitylivingbase.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity entitylivingbase = this.attacker.m_5448_();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.m_6084_()) {
            return false;
        }
        if (!this.longMemory) {
            return !this.attacker.m_21573_().m_26571_();
        }
        if (!this.attacker.m_21444_(entitylivingbase.m_142538_())) {
            return false;
        }
        return !(entitylivingbase instanceof Player) || !entitylivingbase.m_5833_() && !((Player)entitylivingbase).m_7500_();
    }

    public void m_8056_() {
        this.attacker.m_21573_().m_26536_(this.path, this.speedTowardsTarget);
        this.delayCounter = 0;
    }

    public void m_8041_() {
        LivingEntity entitylivingbase = this.attacker.m_5448_();
        if (entitylivingbase instanceof Player && (entitylivingbase.m_5833_() || ((Player)entitylivingbase).m_7500_())) {
            this.attacker.m_6710_(null);
        }
        this.attacker.m_21573_().m_26573_();
    }

    public void m_8037_() {
        super.m_8037_();
        LivingEntity entitylivingbase = this.attacker.m_5448_();
        this.attacker.m_21563_().m_24960_((Entity)entitylivingbase, 30.0f, 30.0f);
        double d0 = this.attacker.m_20275_(entitylivingbase.m_20185_(), entitylivingbase.m_142469_().f_82289_, entitylivingbase.m_20189_());
        --this.delayCounter;
        if ((this.longMemory || this.attacker.m_21574_().m_148306_((Entity)entitylivingbase)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || entitylivingbase.m_20275_(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.m_21187_().nextFloat() < 0.05f)) {
            this.targetX = entitylivingbase.m_20185_();
            this.targetY = entitylivingbase.m_142469_().f_82289_;
            this.targetZ = entitylivingbase.m_20189_();
            this.delayCounter = 4 + this.attacker.m_21187_().nextInt(7);
            Objects.requireNonNull(this);
            if (d0 > 1024.0) {
                this.delayCounter += 10;
            } else if (d0 > 256.0) {
                this.delayCounter += 5;
            }
            if (!this.attacker.m_21573_().m_5624_((Entity)entitylivingbase, this.speedTowardsTarget)) {
                this.delayCounter += 15;
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
    }

    private double getAttackReachSqr(LivingEntity attackTarget) {
        return this.attacker.m_20205_() * 2.0f * this.attacker.m_20205_() * 2.0f + attackTarget.m_20205_();
    }
}

