/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mysticmods.mysticalworld.MWTags;
import mysticmods.mysticalworld.init.ModEntities;
import mysticmods.mysticalworld.init.ModItems;
import mysticmods.mysticalworld.init.ModSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public class SproutEntity
extends Animal {
    public static final EntityDataAccessor<Integer> variant = SynchedEntityData.m_135353_(SproutEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public SproutEntity(EntityType<? extends SproutEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 3;
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        SproutEntity entity = (SproutEntity)ModEntities.SPROUT.get().m_20615_((Level)world);
        if (entity != null) {
            entity.setVariant(entity.getVariant());
        }
        return entity;
    }

    protected float m_6121_() {
        return 0.2f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.f_19796_.nextInt(45) == 0) {
            return ModSounds.SPROUT_AMBIENT.get();
        }
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(variant, (Object)this.f_19796_.nextInt(4));
    }

    private void setVariant(int variant) {
        this.m_20088_().m_135381_(SproutEntity.variant, (Object)variant);
    }

    private int getVariant() {
        return (Integer)this.m_20088_().m_135370_(variant);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_(MWTags.Items.AUBERGINE), false));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    @Nonnull
    public ResourceLocation m_7582_() {
        return new ResourceLocation("mysticalworld:entities/sprout");
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == ModItems.AUBERGINE.get();
    }

    public float m_6431_(Pose pose, EntityDimensions size) {
        return this.m_6162_() ? this.m_20206_() : 1.3f;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_20088_().m_135381_(variant, (Object)compound.m_128451_("variant"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("variant", ((Integer)this.m_20088_().m_135370_(variant)).intValue());
    }

    public static int StringToVariant(String color) {
        switch (color) {
            case "tan": {
                return 1;
            }
            case "red": {
                return 2;
            }
            case "purple": {
                return 3;
            }
            case "green": {
                return 0;
            }
        }
        return 0;
    }

    public static String VariantToString(int variant) {
        switch (variant) {
            case 0: {
                return "green";
            }
            case 1: {
                return "tan";
            }
            case 2: {
                return "red";
            }
            case 3: {
                return "purple";
            }
        }
        return "INVALID";
    }
}

