/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.entity;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mysticmods.mysticalworld.init.ModEntities;
import mysticmods.mysticalworld.init.ModSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;

public class SilverFoxEntity
extends TamableAnimal {
    private static final EntityDataAccessor<Float> DATA_HEALTH_ID = SynchedEntityData.m_135353_(SilverFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public SilverFoxEntity(EntityType<? extends SilverFoxEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_7105_(false);
        this.f_21364_ = 5;
    }

    public boolean m_6898_(@Nonnull ItemStack stack) {
        return stack.m_41720_() == Items.f_42581_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return ModSounds.FOX_BARK.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return ModSounds.FOX_DEATH.get();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42581_}), false));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, e -> e instanceof Chicken || e instanceof Rabbit));
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 2.0);
    }

    public void m_6710_(@Nullable LivingEntity entitylivingbaseIn) {
        super.m_6710_(entitylivingbaseIn);
        if (entitylivingbaseIn == null) {
            this.setAngry(false);
        } else if (!this.m_21824_()) {
            this.setAngry(true);
        }
    }

    protected void m_8024_() {
        this.f_19804_.m_135381_(DATA_HEALTH_ID, (Object)Float.valueOf(this.m_21223_()));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_HEALTH_ID, (Object)Float.valueOf(this.m_21223_()));
    }

    protected float m_6121_() {
        return 0.3f;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.isAngry()) {
            return ModSounds.FOX_AGGRO.get();
        }
        return ModSounds.FOX_IDLE.get();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isAngry() && this.m_5803_()) {
            this.m_21837_(false);
        }
        if (!this.f_19853_.f_46443_ && this.m_5448_() == null && this.isAngry()) {
            this.setAngry(false);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (this.m_5803_()) {
            this.m_21837_(false);
        }
        this.m_21839_(false);
        if (entity != null && !(entity instanceof Player) && !(entity instanceof Arrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
            this.m_5496_(ModSounds.FOX_BITE.get(), 1.0f, 1.0f);
        }
        return flag;
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(10.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(5.0);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || item == Items.f_42410_ && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            InteractionResult actionresulttype;
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                FoodProperties food;
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                if ((food = item.m_41473_()) != null) {
                    this.m_5634_(food.m_38744_());
                    return InteractionResult.SUCCESS;
                }
            }
            if ((!(actionresulttype = super.m_6071_(player, hand)).m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player)) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            return actionresulttype;
        }
        if (item == Items.f_42410_) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean isAngry() {
        return ((Byte)this.f_19804_.m_135370_(f_21798_) & 2) != 0;
    }

    public void setAngry(boolean angry) {
        byte b0 = (Byte)this.f_19804_.m_135370_(f_21798_);
        if (angry) {
            this.f_19804_.m_135381_(f_21798_, (Object)((byte)(b0 | 2)));
        } else {
            this.f_19804_.m_135381_(f_21798_, (Object)((byte)(b0 & 0xFFFFFFFD)));
        }
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof Creeper) && !(target instanceof Ghast)) {
            SilverFoxEntity entityfox;
            if (target instanceof SilverFoxEntity && (entityfox = (SilverFoxEntity)target).m_21824_() && entityfox.m_142480_() == owner) {
                return false;
            }
            if (target instanceof Player && owner instanceof Player && !((Player)owner).m_7099_((Player)target)) {
                return false;
            }
            return !(target instanceof AbstractHorse) || !((AbstractHorse)target).m_30614_();
        }
        return false;
    }

    public boolean m_6573_(Player player) {
        return !this.isAngry() && super.m_6573_(player);
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        return (AgeableMob)ModEntities.SILVER_FOX.get().m_20615_((Level)world);
    }

    @Nonnull
    public ResourceLocation m_7582_() {
        return new ResourceLocation("mysticalworld", "entities/silver_fox");
    }

    public static class SleepGoal
    extends Goal {
        private final SilverFoxEntity tameable;
        private boolean isSleeping;

        public SleepGoal(SilverFoxEntity entityIn) {
            this.tameable = entityIn;
            EnumSet mutexes = this.m_7684_();
            mutexes.add(Goal.Flag.JUMP);
            this.m_7021_(mutexes);
        }

        public boolean m_8036_() {
            if (!this.tameable.m_21824_()) {
                return false;
            }
            if (this.tameable.m_20069_()) {
                return false;
            }
            if (!this.tameable.f_19861_) {
                return false;
            }
            LivingEntity entitylivingbase = this.tameable.m_142480_();
            if (entitylivingbase == null) {
                return true;
            }
            return !(this.tameable.m_20280_((Entity)entitylivingbase) < 144.0 && entitylivingbase.m_142581_() != null || !this.isSleeping);
        }

        public void m_8056_() {
            this.tameable.m_21573_().m_26573_();
            this.tameable.m_21837_(true);
        }

        public void m_8041_() {
            this.tameable.m_21837_(false);
        }

        public void setSleeping(boolean sleeping) {
            this.isSleeping = sleeping;
        }
    }
}

