/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.entity;

import mysticmods.mysticalworld.config.ConfigManager;
import mysticmods.mysticalworld.init.ModItems;
import mysticmods.mysticalworld.init.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ForgeHooks;

public class SilkwormEntity
extends Animal {
    public static ResourceLocation LOOT_TABLE = new ResourceLocation("mysticalworld", "entity/silkworm");
    private static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.m_135353_(SilkwormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LEAVES_CONSUMED = SynchedEntityData.m_135353_(SilkwormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int MAX_SIZE = 120;
    private ItemEntity leafTarget;
    private int lastTickPlayed = 0;

    public SilkwormEntity(EntityType<? extends Animal> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 1;
    }

    public void setLeafTarget(ItemEntity leaf) {
        this.leafTarget = leaf;
    }

    public ItemEntity getLeafTarget() {
        return this.leafTarget;
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        return null;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.5, false));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 0.9, Ingredient.m_204132_((TagKey)ItemTags.f_13143_), false));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, SilkwormEntity.class, false));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SIZE, (Object)0);
        this.f_19804_.m_135372_(LEAVES_CONSUMED, (Object)0);
    }

    public int getLeavesConsumed() {
        return (Integer)this.f_19804_.m_135370_(LEAVES_CONSUMED);
    }

    public void setLeavesConsumed(int amount) {
        this.f_19804_.m_135381_(LEAVES_CONSUMED, (Object)amount);
    }

    public void resetLeaves() {
        this.f_19804_.m_135381_(LEAVES_CONSUMED, (Object)0);
    }

    private boolean shouldPlaySound() {
        return this.f_19797_ - this.lastTickPlayed > 8;
    }

    public void eatLeaves() {
        this.incLeaves();
        for (int i = 0; i < 1 + this.f_19796_.nextInt(3); ++i) {
            this.grow();
        }
        this.m_5634_(1.0f);
        if (this.shouldPlaySound()) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), ModSounds.SILKWORM_EAT.get(), SoundSource.NEUTRAL, 0.5f, 1.2f + this.f_19796_.nextFloat() * 0.02f);
            this.lastTickPlayed = this.f_19797_;
        }
    }

    private void incLeaves() {
        this.f_19804_.m_135381_(LEAVES_CONSUMED, (Object)(this.getLeavesConsumed() + 1));
    }

    public int getSize() {
        return (Integer)this.f_19804_.m_135370_(SIZE);
    }

    public void setSize(int size) {
        this.f_19804_.m_135381_(SIZE, (Object)size);
    }

    private void incSize() {
        if (!this.m_6162_()) {
            this.f_19804_.m_135381_(SIZE, (Object)(this.getSize() + 1));
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack;
        if (!player.f_19853_.f_46443_ && (itemstack = player.m_21120_(hand)).m_204117_(ItemTags.f_13143_)) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            this.eatLeaves();
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public float m_20236_(Pose pose) {
        return 0.1f;
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.15);
    }

    protected SoundEvent m_7515_() {
        if (this.f_19853_.f_46441_.nextInt(4) == 0) {
            return ModSounds.SILKWORM_AMBIENT.get();
        }
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return ModSounds.SILKWORM_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return ModSounds.SILKWORM_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(ModSounds.SILKWORM_STEP.get(), 0.15f, 1.3f + (this.f_19853_.f_46441_.nextFloat() - 0.5f));
    }

    public ResourceLocation m_7582_() {
        return LOOT_TABLE;
    }

    protected float m_6121_() {
        return 0.2f;
    }

    public float m_6100_() {
        return 1.3f + this.f_19796_.nextFloat() - 0.5f;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSize(compound.m_128451_("Size"));
        this.setLeavesConsumed(compound.m_128451_("Leaves"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Size", this.getSize());
        compound.m_128405_("Leaves", this.getLeavesConsumed());
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource pDamageSource) {
        float[] ret = ForgeHooks.onLivingFall((LivingEntity)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return false;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        MobEffectInstance potioneffect = this.m_21124_(MobEffects.f_19603_);
        float f = potioneffect == null ? 0.0f : (float)(potioneffect.m_19564_() + 1);
        int i = Mth.m_14167_((float)((distance - 3.0f - f) * damageMultiplier));
        if (i > 0) {
            this.m_5496_(this.getFallDamageSound(i), 1.0f, 1.0f);
            int j = Mth.m_14107_((double)this.m_20185_());
            int k = Mth.m_14107_((double)(this.m_20186_() - 0.2));
            int l = Mth.m_14107_((double)this.m_20189_());
            BlockState iblockstate = this.f_19853_.m_8055_(new BlockPos(j, k, l));
            if (iblockstate.m_60767_() != Material.f_76296_) {
                SoundType soundtype = iblockstate.m_60734_().getSoundType(iblockstate, (LevelReader)this.f_19853_, new BlockPos(j, k, l), (Entity)this);
                this.m_5496_(soundtype.m_56779_(), soundtype.m_56773_() * 0.5f, soundtype.m_56774_() * 0.75f);
            }
        }
        return false;
    }

    private SoundEvent getFallDamageSound(int pHeight) {
        return pHeight > 4 ? this.m_196493_().f_196627_() : this.m_196493_().f_196626_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.f_19796_.nextInt(ConfigManager.SILKWORM_CONFIG.getGrowthChance()) == 0) {
            this.grow();
        }
    }

    public void grow() {
        int size = this.getSize();
        if (size == 120) {
            this.setSize(0);
            if (this.m_6142_()) {
                int quantity = Math.max(1, Math.min(5, this.f_19796_.nextInt(Math.max(this.getLeavesConsumed() % 8, 1))));
                this.m_20000_((ItemLike)ModItems.SILK_COCOON.get(), quantity);
                this.resetLeaves();
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), ModSounds.SILKWORM_PLOP.get(), SoundSource.NEUTRAL, 0.5f, 1.2f + this.f_19796_.nextFloat() - 0.5f);
            }
        } else {
            this.incSize();
        }
    }

    public boolean m_7327_(Entity entityIn) {
        if (entityIn instanceof SilkwormEntity) {
            SilkwormEntity other = (SilkwormEntity)entityIn;
            if (other.getSize() > this.getSize()) {
                return false;
            }
            boolean result = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), 2.1474836E9f);
            if (result) {
                this.grow();
            }
            return result;
        }
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }
}

