/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.entity;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mysticmods.mysticalworld.init.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;

public class OwlEntity
extends TamableAnimal
implements FlyingAnimal {
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    private float nextFlap = 1.0f;

    public OwlEntity(EntityType<? extends TamableAnimal> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 15, false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22280_, 0.55);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation pathnavigateflying = new FlyingPathNavigation((Mob)this, worldIn);
        pathnavigateflying.m_26440_(false);
        pathnavigateflying.m_26443_(true);
        return pathnavigateflying;
    }

    public float m_20236_(Pose pose) {
        return this.m_20206_() * 0.6f;
    }

    public void m_8119_() {
        super.m_8119_();
        this.calculateFlapping();
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(this.f_19861_ ? -1 : 4) * 0.3);
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.f_19861_ && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        Vec3 motion = this.m_20184_();
        if (!this.f_19861_ && motion.f_82480_ < 0.0) {
            this.m_20334_(motion.f_82479_, motion.f_82480_ * 0.6, motion.f_82481_);
        }
        this.flap += this.flapping * 2.0f;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42697_;
    }

    public static boolean placement(EntityType<? extends Animal> pAnimal, LevelAccessor worldIn, MobSpawnType reason, BlockPos blockpos, Random pRandom) {
        BlockState down = worldIn.m_8055_(blockpos.m_7495_());
        Block block = down.m_60734_();
        return block instanceof LeavesBlock || block == Blocks.f_50034_ || block instanceof RotatedPillarBlock && down.m_60767_() == Material.f_76320_ || block == Blocks.f_50016_ && worldIn.m_46803_(blockpos) > 8;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    @Nonnull
    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        return (AgeableMob)ModEntities.OWL.get().m_20615_((Level)world);
    }

    public boolean m_7327_(Entity entityIn) {
        return entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), 3.0f);
    }

    @Nullable
    public SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12226_, 0.15f, 1.0f);
    }

    protected void m_142043_() {
        this.m_5496_(SoundEvents.f_12191_, 0.15f, 1.0f);
        this.nextFlap = this.f_146794_ + this.flapSpeed / 2.0f;
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.nextFlap;
    }

    public float m_6100_() {
        return OwlEntity.getPitch(this.f_19796_);
    }

    private static float getPitch(Random random) {
        return (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f;
    }

    public SoundSource m_5720_() {
        return SoundSource.NEUTRAL;
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_7324_(Entity entityIn) {
        if (!(entityIn instanceof Player)) {
            super.m_7324_(entityIn);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_142592_() {
        return !this.f_19861_;
    }
}

