/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.entity;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import mysticmods.mysticalworld.init.ModEntities;
import mysticmods.mysticalworld.init.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.ForgeEventFactory;

public class LavaCatEntity
extends TamableAnimal {
    private static final ResourceLocation LOOT_TABLE = new ResourceLocation("mysticalworld", "entity/lava_cat");
    private static final EntityDataAccessor<Boolean> IS_LAVA = SynchedEntityData.m_135353_(LavaCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UUID OBSIDIAN_SPEED_MODIFIER = UUID.fromString("f58f95e9-fb51-4604-a66d-89433c9dd8a5");
    private static final AttributeModifier OBSIDIAN_SPEED = new AttributeModifier(OBSIDIAN_SPEED_MODIFIER, "Speed debuff for being obsidian", -0.05, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public LavaCatEntity(EntityType<? extends TamableAnimal> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 0.6, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42585_}), false));
        this.f_21345_.m_25352_(5, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.f_21345_.m_25352_(8, (Goal)new OcelotAttackGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new BreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(10, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8, 1));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static boolean placement(EntityType<? extends Animal> pAnimal, LevelAccessor worldIn, MobSpawnType reason, BlockPos blockpos, Random pRandom) {
        Block block = worldIn.m_8055_(blockpos.m_7495_()).m_60734_();
        return block == Blocks.f_50134_ || block == Blocks.f_50080_ || block == Blocks.f_50450_ || block == Blocks.f_50135_ || block == Blocks.f_50136_ || block == Blocks.f_50197_ || block == Blocks.f_50453_ || block == Blocks.f_50451_ || block == Blocks.f_49998_ || block == Blocks.f_50722_ || block == Blocks.f_50331_ || block == Blocks.f_50452_ || block == Blocks.f_50712_ || block == Blocks.f_50137_ || block == Blocks.f_50138_ || block == Blocks.f_50713_ || block == Blocks.f_50730_ || block == Blocks.f_50737_ || block == Blocks.f_50706_ || block == Blocks.f_50734_ || block == Blocks.f_50736_ || block == Blocks.f_50699_ || block == Blocks.f_50697_ || block == Blocks.f_50692_ || block == Blocks.f_49994_ || block == Blocks.f_50141_ || block == Blocks.f_50735_ || block == Blocks.f_50690_ || block == Blocks.f_50701_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_LAVA, (Object)true);
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            double d0 = this.m_21566_().m_24999_();
            if (d0 == 0.6) {
                this.m_20260_(true);
                this.m_6858_(false);
            } else if (d0 == 1.33) {
                this.m_20260_(false);
                this.m_6858_(true);
            } else {
                this.m_20260_(false);
                this.m_6858_(false);
            }
        } else {
            this.m_20260_(false);
            this.m_6858_(false);
        }
    }

    public boolean m_6785_(double distance) {
        return !this.m_21824_() && this.f_19797_ > 2400;
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 2.0);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_21824_()) {
            if (this.m_27593_()) {
                return ModSounds.LAVA_CAT_PURR.get();
            }
            return this.f_19796_.nextInt(4) == 0 ? ModSounds.LAVA_CAT_PURREOW.get() : ModSounds.LAVA_CAT_AMBIENT.get();
        }
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return ModSounds.LAVA_CAT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return ModSounds.LAVA_CAT_DEATH.get();
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public boolean m_7327_(Entity entityIn) {
        EntityDamageSource damage = new EntityDamageSource("mob", (Entity)this);
        damage.m_19386_();
        float amount = 3.0f;
        if (this.getIsLava()) {
            damage.m_19383_().m_19380_();
        } else {
            amount = 6.0f;
        }
        return entityIn.m_6469_((DamageSource)damage, amount);
    }

    public void m_20254_(int seconds) {
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        this.m_21839_(false);
        if (source.m_19384_()) {
            return false;
        }
        if (source == DamageSource.f_19320_ || source == DamageSource.f_19321_) {
            return false;
        }
        boolean lava = this.getIsLava();
        if (!lava && !source.m_19387_()) {
            amount /= 2.0f;
        }
        if (lava && source.m_19387_()) {
            amount /= 2.0f;
        }
        if (this.m_21824_() && source.m_7639_() != null && source.m_7639_() == this.m_142480_() && !source.m_7639_().m_6144_()) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7301_(MobEffectInstance pPotioneffect) {
        if (pPotioneffect.m_19544_() == MobEffects.f_19614_ || pPotioneffect.m_19544_() == MobEffects.f_19615_) {
            return false;
        }
        return super.m_7301_(pPotioneffect);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || item == Items.f_42585_ && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(2.0f);
                return InteractionResult.SUCCESS;
            }
            InteractionResult actionresulttype = super.m_6071_(player, hand);
            if ((!actionresulttype.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player)) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            return actionresulttype;
        }
        if (item == Items.f_42585_) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        LavaCatEntity lavacat = (LavaCatEntity)ModEntities.LAVA_CAT.get().m_20615_((Level)world);
        if (this.m_21824_() && lavacat != null) {
            lavacat.m_21816_(this.m_142504_());
            lavacat.m_7105_(true);
            lavacat.setIsLava(this.getIsLava());
        }
        return lavacat;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42593_;
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.m_21824_()) {
            return false;
        }
        if (!(otherAnimal instanceof LavaCatEntity)) {
            return false;
        }
        LavaCatEntity lavacat = (LavaCatEntity)otherAnimal;
        if (!lavacat.m_21824_()) {
            return false;
        }
        return this.m_27593_() && lavacat.m_27593_();
    }

    public boolean getIsLava() {
        return (Boolean)this.f_19804_.m_135370_(IS_LAVA);
    }

    public void setIsLava(boolean val) {
        this.f_19804_.m_135381_(IS_LAVA, (Object)val);
        AttributeInstance instance = this.m_21051_(Attributes.f_22279_);
        if (instance != null) {
            if (val && instance.m_22109_(OBSIDIAN_SPEED)) {
                instance.m_22130_(OBSIDIAN_SPEED);
            } else if (!instance.m_22109_(OBSIDIAN_SPEED)) {
                instance.m_22118_(OBSIDIAN_SPEED);
            }
        }
    }

    protected void m_5849_() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getIsLava() && this.f_19853_.m_46758_(this.m_142538_()) && this.f_19853_.m_46861_(this.m_142538_()) && this.f_19796_.nextInt(30) == 0) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), ModSounds.LAVA_CAT_SIZZLE.get(), SoundSource.NEUTRAL, 0.2f, 1.3f);
        }
        if (this.getIsLava() && this.f_19798_) {
            this.setIsLava(false);
        } else if (!this.getIsLava() && this.m_20077_()) {
            this.setIsLava(true);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsLava", this.getIsLava());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setIsLava(compound.m_128471_("IsLava"));
    }

    public Component m_7755_() {
        Component itextcomponent = this.m_7770_();
        if (itextcomponent != null) {
            return super.m_7755_();
        }
        if (this.getIsLava()) {
            return new TranslatableComponent("mysticalworld.entity.lava_cat");
        }
        return new TranslatableComponent("mysticalworld.entity.obsidian_cat");
    }
}

