/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.entity;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import mysticmods.mysticalworld.init.ModEntities;
import mysticmods.mysticalworld.init.ModSounds;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FrogEntity
extends Animal {
    public float offGround = 0.0f;

    public FrogEntity(EntityType<? extends FrogEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 2;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pEntity) {
        return (AgeableMob)ModEntities.FROG.get().m_20615_((Level)pLevel);
    }

    public void m_6475_(@Nonnull DamageSource source, float amount) {
        if (!source.m_19385_().equalsIgnoreCase(DamageSource.f_19315_.m_19385_())) {
            super.m_6475_(source, amount);
        }
    }

    public boolean m_6898_(@Nonnull ItemStack stack) {
        return stack.m_41720_() == Items.f_41952_;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 0.75));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 0.75, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50072_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 0.75));
        this.f_21345_.m_25352_(4, (Goal)new GoalFrogJump(this));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19861_ && (Math.abs(this.m_20184_().f_82479_) > 0.05 || Math.abs(this.m_20184_().f_82481_) > 0.05)) {
            this.m_6135_();
        }
        this.offGround = !this.f_19861_ ? (this.offGround += 0.25f) : 0.0f;
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7515_() {
        if (this.f_19796_.nextInt(6) == 0) {
            return ModSounds.FROG_AMBIENT.get();
        }
        return null;
    }

    public float getOffGround(float pTicks) {
        if (!this.f_19861_) {
            return Math.min(1.0f, this.offGround + pTicks * 0.25f);
        }
        return 0.0f;
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.5);
    }

    public static class GoalFrogJump
    extends Goal {
        FrogEntity frog;

        public GoalFrogJump(FrogEntity entity) {
            this.frog = entity;
            EnumSet mutexes = this.m_7684_();
            mutexes.add(Goal.Flag.JUMP);
            this.m_7021_(mutexes);
        }

        public boolean m_8036_() {
            return (this.frog.f_19861_ || this.frog.f_19798_) && (this.frog.f_19797_ + this.frog.m_142049_()) % 20 == 0 && this.frog.f_19796_.nextBoolean();
        }

        public void m_8056_() {
            float ang = this.frog.f_19796_.nextFloat() * (float)Math.PI * 2.0f;
            this.frog.m_20256_(new Vec3(Math.sin(ang) * 0.25, 0.375 + 0.125 * (double)this.frog.f_19796_.nextFloat(), Math.cos(ang) * 0.25));
            this.frog.m_21563_().m_24950_(this.frog.m_20185_() + this.frog.m_20184_().f_82479_ * 60.0, this.frog.m_20186_(), this.frog.m_20189_() + this.frog.m_20184_().f_82481_ * 60.0, (float)this.frog.m_8085_(), (float)this.frog.m_8132_());
        }
    }
}

