/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.entity;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import mysticmods.mysticalworld.entity.ai.StalkGoal;
import mysticmods.mysticalworld.init.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class EnderminiEntity
extends PathfinderMob {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("mysticalworld", "entity/endermini");
    private static final Set<Block> CARRIABLE_BLOCKS = Sets.newIdentityHashSet();
    private static final EntityDataAccessor<Optional<BlockState>> CARRIED_BLOCK = SynchedEntityData.m_135353_(EnderminiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private static final EntityDataAccessor<Boolean> SCREAMING = SynchedEntityData.m_135353_(EnderminiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int lastCreepySound;
    private int targetChangeTime;
    private static final String BETTERENDFORGE = "betterendforge";
    private static MobEffect END_VEIL_EFFECT = null;
    private static Enchantment END_VEIL_ENCHANTMENT = null;
    private static int betterEnd = 0;

    public EnderminiEntity(EntityType<? extends EnderminiEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_19793_ = 1.0f;
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new StareGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new StalkGoal(this, 2.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new InteractGoal((Mob)this, Player.class, 32.0f, 1.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new PlaceBlockGoal(this));
        this.f_21345_.m_25352_(11, (Goal)new TakeBlockGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new FindPlayerGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Player.class}));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
    }

    public static AttributeSupplier.Builder attributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, 0.5).m_22268_(Attributes.f_22277_, 64.0);
    }

    public void m_6710_(@Nullable LivingEntity entitylivingbaseIn) {
        super.m_6710_(entitylivingbaseIn);
        if (entitylivingbaseIn == null) {
            this.targetChangeTime = 0;
            this.f_19804_.m_135381_(SCREAMING, (Object)false);
        } else {
            this.targetChangeTime = this.f_19797_;
            this.f_19804_.m_135381_(SCREAMING, (Object)true);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CARRIED_BLOCK, Optional.empty());
        this.f_19804_.m_135372_(SCREAMING, (Object)false);
    }

    public void playEnderminiSound() {
        if (this.f_19797_ >= this.lastCreepySound + 400) {
            this.lastCreepySound = this.f_19797_;
            if (!this.m_20067_()) {
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), ModSounds.ENDERMINI_STARE.get(), this.m_5720_(), 2.5f, 1.0f);
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (SCREAMING.equals(key) && this.isScreaming() && this.f_19853_.f_46443_) {
            this.playEnderminiSound();
        }
        super.m_7350_(key);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        BlockState iblockstate = this.getHeldBlockState();
        if (iblockstate != null) {
            compound.m_128376_("carried", (short)Block.m_49956_((BlockState)iblockstate));
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        BlockState iblockstate = null;
        if (compound.m_128425_("carried", 8)) {
            iblockstate = Block.m_49803_((int)compound.m_128448_("carried"));
        }
        if (iblockstate == null || iblockstate.m_60734_() == null || iblockstate.m_60767_() == Material.f_76296_) {
            iblockstate = null;
        }
        this.setHeldBlock(iblockstate);
    }

    public float m_20236_(Pose pPose) {
        return 1.0f;
    }

    public void m_8107_() {
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.nextDouble() * (double)this.m_20206_() - 0.25, this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_(), (this.f_19796_.nextDouble() - 0.5) * 2.0, -this.f_19796_.nextDouble(), (this.f_19796_.nextDouble() - 0.5) * 2.0);
            }
        }
        this.f_20899_ = false;
        super.m_8107_();
    }

    protected void m_8024_() {
        if (this.m_20070_()) {
            this.m_6469_(DamageSource.f_19312_, 1.0f);
        }
        if (this.f_19797_ >= this.targetChangeTime + 600 && this.f_19853_.m_46861_(this.m_142538_()) && this.f_19796_.nextFloat() * 30.0f < 1.2f) {
            this.m_6710_(null);
            this.teleportRandomly();
        }
        super.m_8024_();
    }

    protected boolean teleportRandomly() {
        double d0 = this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * 64.0;
        double d1 = this.m_20186_() + (double)(this.f_19796_.nextInt(64) - 32);
        double d2 = this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * 64.0;
        return this.teleport(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity p_70816_1_) {
        Vec3 vec3d = new Vec3(this.m_20185_() - p_70816_1_.m_20185_(), this.m_142469_().f_82289_ + (double)(this.m_20206_() / 2.0f) - p_70816_1_.m_20186_() + (double)p_70816_1_.m_20192_(), this.m_20189_() - p_70816_1_.m_20189_());
        vec3d = vec3d.m_82541_();
        double d1 = this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * 8.0 - vec3d.f_82479_ * 16.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.nextInt(16) - 8) - vec3d.f_82480_ * 16.0;
        double d3 = this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * 8.0 - vec3d.f_82481_ * 16.0;
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double pX, double pY, double pZ) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(pX, pY, pZ);
        while (blockpos$mutableblockpos.m_123342_() > this.f_19853_.m_141937_() && !this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60767_().m_76334_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_60767_().m_76334_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)pX, (double)pY, (double)pZ);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.m_20067_()) {
                this.f_19853_.m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, ModSounds.ENDERMINI_PORTAL.get(), this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(ModSounds.ENDERMINI_PORTAL.get(), 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return this.isScreaming() ? ModSounds.ENDERMINI_SCREAM.get() : ModSounds.ENDERMINI_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return ModSounds.ENDERMINI_HIT.get();
    }

    protected SoundEvent m_5592_() {
        return ModSounds.ENDERMINI_DEATH.get();
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        BlockState iblockstate = this.getHeldBlockState();
        if (iblockstate != null) {
            Item item = Item.m_41439_((Block)iblockstate.m_60734_());
            this.m_5552_(new ItemStack((ItemLike)item, 1), 0.0f);
        }
    }

    private void setHeldBlock(@Nullable BlockState state) {
        this.f_19804_.m_135381_(CARRIED_BLOCK, Optional.ofNullable(state));
    }

    @Nullable
    public BlockState getHeldBlockState() {
        return ((Optional)this.f_19804_.m_135370_(CARRIED_BLOCK)).orElse(null);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (source instanceof IndirectEntityDamageSource) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return false;
        }
        boolean flag = super.m_6469_(source, amount);
        if (source.m_19376_() && this.f_19796_.nextInt(10) != 0) {
            this.teleportRandomly();
        }
        return flag;
    }

    public static void setCarriable(Block block, boolean canCarry) {
        if (canCarry) {
            CARRIABLE_BLOCKS.add(block);
        } else {
            CARRIABLE_BLOCKS.remove(block);
        }
    }

    public static boolean getCarriable(Block block) {
        return CARRIABLE_BLOCKS.contains(block);
    }

    public boolean isScreaming() {
        return (Boolean)this.f_19804_.m_135370_(SCREAMING);
    }

    private boolean shouldFollowPlayer(Player player) {
        ItemStack itemstack = (ItemStack)player.m_150109_().f_35975_.get(3);
        if (itemstack.m_41720_() == Items.f_42046_) {
            return false;
        }
        Vec3 vec3d = player.m_20252_(1.0f).m_82541_();
        Vec3 vec3d1 = new Vec3(this.m_20185_() - player.m_20185_(), this.m_142469_().f_82289_ + (double)this.m_20192_() - (player.m_20186_() + (double)player.m_20192_()), this.m_20189_() - player.m_20189_());
        double d0 = vec3d1.m_82553_();
        double d1 = vec3d.m_82526_(vec3d1 = vec3d1.m_82541_());
        return d1 > 1.0 - 0.025 / d0 && player.m_142582_((Entity)this);
    }

    private boolean shouldAttackPlayer(Player player) {
        ItemStack itemstack;
        if (betterEnd == 0) {
            if (END_VEIL_EFFECT == null) {
                END_VEIL_EFFECT = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(BETTERENDFORGE, "end_veil"));
            }
            if (END_VEIL_ENCHANTMENT == null) {
                END_VEIL_ENCHANTMENT = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(BETTERENDFORGE, "end_veil"));
            }
            betterEnd = END_VEIL_EFFECT == null || END_VEIL_ENCHANTMENT == null ? -1 : 1;
        }
        if ((itemstack = (ItemStack)player.m_150109_().f_35975_.get(3)).m_41720_() == Blocks.f_50143_.m_5456_()) {
            return false;
        }
        if (betterEnd == 1 && (player.m_21023_(END_VEIL_EFFECT) || EnchantmentHelper.m_44836_((Enchantment)END_VEIL_ENCHANTMENT, (LivingEntity)player) > 0)) {
            return false;
        }
        Vec3 vec3d = player.m_20252_(1.0f).m_82541_();
        Vec3 vec3d1 = new Vec3(this.m_20185_() - player.m_20185_(), this.m_142469_().f_82289_ + (double)this.m_20192_() - (player.m_20186_() + (double)player.m_20192_()), this.m_20189_() - player.m_20189_());
        double d0 = vec3d1.m_82553_();
        double d1 = vec3d.m_82526_(vec3d1 = vec3d1.m_82541_());
        return d1 > 1.0 - 0.025 / d0 && player.m_142582_((Entity)this);
    }

    public void setCarriedBlock(@Nullable BlockState pState) {
        this.f_19804_.m_135381_(CARRIED_BLOCK, Optional.ofNullable(pState));
    }

    public static boolean checkMonsterSpawnRules(EntityType<EnderminiEntity> pType, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, Random pRandom) {
        return EnderminiEntity.m_21400_(pType, (LevelAccessor)pLevel, (MobSpawnType)pReason, (BlockPos)pPos, (Random)pRandom);
    }

    static {
        CARRIABLE_BLOCKS.add(Blocks.f_50034_);
        CARRIABLE_BLOCKS.add(Blocks.f_50493_);
        CARRIABLE_BLOCKS.add(Blocks.f_49992_);
        CARRIABLE_BLOCKS.add(Blocks.f_49994_);
        CARRIABLE_BLOCKS.add(Blocks.f_50111_);
        CARRIABLE_BLOCKS.add(Blocks.f_50112_);
        CARRIABLE_BLOCKS.add(Blocks.f_50072_);
        CARRIABLE_BLOCKS.add(Blocks.f_50073_);
        CARRIABLE_BLOCKS.add(Blocks.f_50077_);
        CARRIABLE_BLOCKS.add(Blocks.f_50128_);
        CARRIABLE_BLOCKS.add(Blocks.f_50129_);
        CARRIABLE_BLOCKS.add(Blocks.f_50133_);
        CARRIABLE_BLOCKS.add(Blocks.f_50186_);
        CARRIABLE_BLOCKS.add(Blocks.f_50195_);
        CARRIABLE_BLOCKS.add(Blocks.f_50134_);
    }

    static class StareGoal
    extends Goal {
        private final EnderminiEntity enderman;

        public StareGoal(EnderminiEntity p_i50520_1_) {
            this.enderman = p_i50520_1_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.enderman.m_5448_();
            if (!(livingentity instanceof Player)) {
                return false;
            }
            double d0 = livingentity.m_20280_((Entity)this.enderman);
            return !(d0 > 256.0) && this.enderman.shouldAttackPlayer((Player)livingentity);
        }

        public void m_8056_() {
            this.enderman.m_21573_().m_26573_();
        }
    }

    static class PlaceBlockGoal
    extends Goal {
        private final EnderminiEntity enderman;

        public PlaceBlockGoal(EnderminiEntity p_i45843_1_) {
            this.enderman = p_i45843_1_;
        }

        public boolean m_8036_() {
            if (this.enderman.getHeldBlockState() == null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.enderman.f_19853_, (Entity)this.enderman)) {
                return false;
            }
            return this.enderman.m_21187_().nextInt(2000) == 0;
        }

        public void m_8037_() {
            Random random = this.enderman.m_21187_();
            Level world = this.enderman.f_19853_;
            int i = Mth.m_14107_((double)(this.enderman.m_20185_() - 1.0 + random.nextDouble() * 2.0));
            int j = Mth.m_14107_((double)(this.enderman.m_20186_() + random.nextDouble() * 2.0));
            int k = Mth.m_14107_((double)(this.enderman.m_20189_() - 1.0 + random.nextDouble() * 2.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = world.m_8055_(blockpos);
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate1 = world.m_8055_(blockpos1);
            BlockState blockstate2 = this.enderman.getHeldBlockState();
            if (blockstate2 != null && this.canPlaceBlock(world, blockpos, blockstate2 = Block.m_49931_((BlockState)blockstate2, (LevelAccessor)this.enderman.f_19853_, (BlockPos)blockpos), blockstate, blockstate1, blockpos1) && !ForgeEventFactory.onBlockPlace((Entity)this.enderman, (BlockSnapshot)BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)blockpos1), (Direction)Direction.UP)) {
                world.m_7731_(blockpos, blockstate2, 3);
                this.enderman.setCarriedBlock(null);
            }
        }

        private boolean canPlaceBlock(Level p_220836_1_, BlockPos p_220836_2_, BlockState p_220836_3_, BlockState p_220836_4_, BlockState p_220836_5_, BlockPos p_220836_6_) {
            return p_220836_4_.m_60795_() && !p_220836_5_.m_60795_() && !p_220836_5_.m_60713_(Blocks.f_50752_) && p_220836_5_.m_60838_((BlockGetter)p_220836_1_, p_220836_6_) && p_220836_3_.m_60710_((LevelReader)p_220836_1_, p_220836_2_) && p_220836_1_.m_45933_((Entity)this.enderman, AABB.m_82333_((Vec3)Vec3.m_82528_((Vec3i)p_220836_2_))).isEmpty();
        }
    }

    static class TakeBlockGoal
    extends Goal {
        private final EnderminiEntity enderman;

        public TakeBlockGoal(EnderminiEntity p_i45841_1_) {
            this.enderman = p_i45841_1_;
        }

        public boolean m_8036_() {
            if (this.enderman.getHeldBlockState() != null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.enderman.f_19853_, (Entity)this.enderman)) {
                return false;
            }
            return this.enderman.m_21187_().nextInt(20) == 0;
        }

        public void m_8037_() {
            boolean flag;
            Vec3 vec3d1;
            Random random = this.enderman.m_21187_();
            Level world = this.enderman.f_19853_;
            int i = Mth.m_14107_((double)(this.enderman.m_20185_() - 2.0 + random.nextDouble() * 4.0));
            int j = Mth.m_14107_((double)(this.enderman.m_20186_() + random.nextDouble() * 3.0));
            int k = Mth.m_14107_((double)(this.enderman.m_20189_() - 2.0 + random.nextDouble() * 4.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = world.m_8055_(blockpos);
            Vec3 vec3d = new Vec3((double)Mth.m_14107_((double)this.enderman.m_20185_()) + 0.5, (double)j + 0.5, (double)Mth.m_14107_((double)this.enderman.m_20189_()) + 0.5);
            BlockHitResult blockraytraceresult = world.m_45547_(new ClipContext(vec3d, vec3d1 = new Vec3((double)i + 0.5, (double)j + 0.5, (double)k + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.enderman));
            boolean bl = flag = blockraytraceresult.m_6662_() != HitResult.Type.MISS && blockraytraceresult.m_82425_().equals((Object)blockpos);
            if (blockstate.m_204336_(BlockTags.f_13046_) && flag) {
                this.enderman.setCarriedBlock(blockstate);
                world.m_7471_(blockpos, false);
            }
        }
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final EnderminiEntity enderman;
        private Player player;
        private int aggroTime;
        private int teleportTime;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.m_148352_().m_26893_();

        public FindPlayerGoal(EnderminiEntity p_i45842_1_) {
            super((Mob)p_i45842_1_, Player.class, false);
            this.enderman = p_i45842_1_;
            this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(p_220790_1_ -> p_i45842_1_.shouldAttackPlayer((Player)p_220790_1_));
        }

        public boolean m_8036_() {
            this.player = this.enderman.f_19853_.m_45946_(this.startAggroTargetConditions, (LivingEntity)this.enderman);
            return this.player != null;
        }

        public void m_8056_() {
            this.aggroTime = 5;
            this.teleportTime = 0;
        }

        public void m_8041_() {
            this.player = null;
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.player != null) {
                if (!this.enderman.shouldAttackPlayer(this.player)) {
                    return false;
                }
                this.enderman.m_21391_((Entity)this.player, 10.0f, 10.0f);
                return true;
            }
            return this.f_26050_ != null && this.continueAggroTargetConditions.m_26885_((LivingEntity)this.enderman, this.f_26050_) || super.m_8045_();
        }

        public void m_8037_() {
            if (this.player != null) {
                if (--this.aggroTime <= 0) {
                    this.f_26050_ = this.player;
                    this.player = null;
                    super.m_8056_();
                }
            } else {
                if (this.f_26050_ != null && !this.enderman.m_20159_()) {
                    if (this.enderman.shouldAttackPlayer((Player)this.f_26050_)) {
                        if (this.f_26050_.m_20280_((Entity)this.enderman) < 16.0) {
                            this.enderman.teleportRandomly();
                        }
                        this.teleportTime = 0;
                    } else if (this.f_26050_.m_20280_((Entity)this.enderman) > 256.0 && this.teleportTime++ >= 30 && this.enderman.teleportToEntity((Entity)this.f_26050_)) {
                        this.teleportTime = 0;
                    }
                }
                super.m_8037_();
            }
        }
    }
}

