/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.config;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mysticmods.mysticalworld.config.AbstractConfig;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;

public class OreConfig
extends AbstractConfig {
    private final String name;
    private final int chance;
    private final int minY;
    private final int maxY;
    private final int size;
    private final List<ResourceKey<Level>> dimensions;
    private ForgeConfigSpec.IntValue configChance;
    private ForgeConfigSpec.IntValue configMinY;
    private ForgeConfigSpec.IntValue configMaxY;
    private ForgeConfigSpec.IntValue configSize;
    private ForgeConfigSpec.ConfigValue<List<? extends String>> configDimensions;
    private Set<ResourceKey<Level>> storedDimension = null;

    public OreConfig(String name, int chance, int minY, int maxY, int size, List<ResourceKey<Level>> dimensions) {
        this.name = name;
        this.chance = chance;
        this.minY = minY;
        this.maxY = maxY;
        this.size = size;
        this.dimensions = dimensions;
    }

    public String getName() {
        return this.name;
    }

    public int getChance() {
        return (Integer)this.configChance.get();
    }

    public int getMinY() {
        return (Integer)this.configMinY.get();
    }

    public int getMaxY() {
        return (Integer)this.configMaxY.get();
    }

    public int getSize() {
        return (Integer)this.configSize.get();
    }

    public boolean shouldGenerate() {
        return this.getChance() > 0;
    }

    public Set<ResourceKey<Level>> getDimensions() {
        if (this.storedDimension == null) {
            this.storedDimension = ((List)this.configDimensions.get()).stream().map(o -> ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(o))).collect(Collectors.toSet());
        }
        return this.storedDimension;
    }

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        builder.comment(this.name + " ore generation.").push(this.name + "_oregen");
        this.configChance = builder.comment("Number of veins per chunk (set to 0 to disable).").defineInRange("oreChances", this.chance, 0, 256);
        this.configSize = builder.comment("Max size of the vein.").defineInRange("veinSize", this.size, 1, 256);
        this.configMinY = builder.comment("Number of veins per chunk (set to 0 to disable).").defineInRange("minY", this.minY, 0, 256);
        this.configMaxY = builder.comment("Number of veins per chunk (set to 0 to disable).").defineInRange("maxY", this.maxY, 0, 256);
        this.configDimensions = builder.comment("The dimensions that this ore should spawn in as a list (default [\"minecraft:overworld\"])").defineList("dimensions", this.dimensions.stream().map(ResourceKey::m_135782_).map(ResourceLocation::toString).collect(Collectors.toList()), o -> o instanceof String);
        builder.pop();
    }

    @Override
    public void reset() {
        this.storedDimension = null;
    }
}

