/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.config;

import mysticmods.mysticalworld.config.AbstractConfig;
import net.minecraftforge.common.ForgeConfigSpec;

public class HatConfig
extends AbstractConfig {
    protected ForgeConfigSpec.IntValue configAntlerFrequency;
    protected ForgeConfigSpec.IntValue configAntlerThreshold;
    protected ForgeConfigSpec.DoubleValue configAntlerHealing;
    protected ForgeConfigSpec.IntValue configAntlerRegenDuration;
    protected ForgeConfigSpec.IntValue configAntlerRegenAmplifier;
    protected ForgeConfigSpec.DoubleValue configAntlerHealthBonus;
    protected ForgeConfigSpec.IntValue configAntlerDamage;
    protected ForgeConfigSpec.DoubleValue configMaskDamageBonus;
    public int antlerFrequency = 50;
    public int antlerThreshold = -1;
    public double antlerHealing = 2.0;
    public int antlerRegenDuration = 130;
    public int antlerRegenAmplifier = 1;
    public float antlerHealthBonus = 4.0f;
    public int antlerDamage = 1;
    public double maskBonusDamage = 0.3;

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        this.configAntlerFrequency = builder.comment("Spawn frequency (1 in X chances per tick while spawn conditions are met, -1 for not at all)").defineInRange("antler_frequency", this.antlerFrequency, 0, Integer.MAX_VALUE);
        this.configAntlerThreshold = builder.comment("How many hearts under maximum health the player needs to be for a deer to spawn (-1 for any value under maximum health").defineInRange("antler_threshold", this.antlerThreshold, -1, Integer.MAX_VALUE);
        this.configAntlerHealing = builder.comment("How much a Spirit Deer should heal for").defineInRange("antler_healing", this.antlerHealing, 0.5, Double.MAX_VALUE);
        this.configAntlerRegenDuration = builder.comment("How long a duration Regeneration should be applied for").defineInRange("antler_regen_duration", this.antlerRegenDuration, 1, Integer.MAX_VALUE);
        this.configAntlerRegenAmplifier = builder.comment("What amplifier should be applied to the Regeneration effect (0 = I, 1 = II, etc)").defineInRange("antler_regen_amplifier", this.antlerRegenAmplifier, 0, Integer.MAX_VALUE);
        this.configAntlerHealthBonus = builder.comment("How much of a health bonus wearing the hat should give (-1 for no bonus, 2 for a single heart, 4 for two hearts, etc").defineInRange("antler_health_bonus", (double)this.antlerHealthBonus, 0.5, Double.MAX_VALUE);
        this.configAntlerDamage = builder.comment("How much damage to the antler hat spawning a spirit deer causes (-1 for no damage)").defineInRange("antler_damage", this.antlerDamage, -1, Integer.MAX_VALUE);
        this.configMaskDamageBonus = builder.comment("How much of a damage to bonus should be provided by the mask (-1 for none)").defineInRange("mask_bonus_damage", this.maskBonusDamage, -1.0, Double.MAX_VALUE);
    }

    public int getAntlerFrequency() {
        return (Integer)this.configAntlerFrequency.get();
    }

    public int getAntlerThreshold() {
        return (Integer)this.configAntlerThreshold.get();
    }

    public float getAntlerHealing() {
        return (float)((Double)this.configAntlerHealing.get()).doubleValue();
    }

    public int getAntlerRegenDuration() {
        return (Integer)this.configAntlerRegenDuration.get();
    }

    public int getAntlerRegenAmplifier() {
        return (Integer)this.configAntlerRegenAmplifier.get();
    }

    public float getAntlerHealthBonus() {
        return (float)((Double)this.configAntlerHealthBonus.get()).doubleValue();
    }

    public int getAntlerDamage() {
        return (Integer)this.configAntlerDamage.get();
    }

    public double getMaskBonusDamage() {
        return (Double)this.configMaskDamageBonus.get();
    }

    @Override
    public void reset() {
    }
}

