/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mysticmods.mysticalworld.config.AbstractConfig;
import mysticmods.mysticalworld.config.ArmorConfig;
import mysticmods.mysticalworld.config.ClamConfig;
import mysticmods.mysticalworld.config.HatConfig;
import mysticmods.mysticalworld.config.HellSproutConfig;
import mysticmods.mysticalworld.config.MobConfig;
import mysticmods.mysticalworld.config.OreConfig;
import mysticmods.mysticalworld.config.SilkwormConfig;
import mysticmods.mysticalworld.config.StonepetalConfig;
import mysticmods.mysticalworld.config.StructureConfig;
import mysticmods.mysticalworld.config.TreeConfig;
import mysticmods.mysticalworld.init.ModFeatures;
import mysticmods.mysticalworld.repack.noobutil.config.IArmorConfig;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="mysticalworld", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigManager {
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec COMMON_CONFIG;
    public static MobConfig DEER_CONFIG;
    public static MobConfig SPROUT_CONFIG;
    public static HellSproutConfig HELL_SPROUT_CONFIG;
    public static MobConfig BEETLE_CONFIG;
    public static MobConfig SILVER_FOX_CONFIG;
    public static MobConfig FROG_CONFIG;
    public static MobConfig ENDERMINI_CONFIG;
    public static MobConfig LAVA_CAT_CONFIG;
    public static MobConfig OWL_CONFIG;
    public static SilkwormConfig SILKWORM_CONFIG;
    public static HatConfig HAT_CONFIG;
    public static TreeConfig DEAD_TREE_CONFIG;
    public static StonepetalConfig STONEPETAL_CONFIG;
    public static StructureConfig HUT_CONFIG;
    public static StructureConfig BARROW_CONFIG;
    public static StructureConfig SAND_HOUSE_CONFIG;
    public static ForgeConfigSpec.BooleanValue SEED_INJECTION;
    public static MobConfig DUCK_CONFIG;
    public static ClamConfig CLAM_CONFIG;
    public static OreConfig TIN_ORE;
    public static OreConfig SILVER_ORE;
    public static OreConfig LEAD_ORE;
    public static OreConfig SAPPHIRE_ORE;
    public static OreConfig GRANITE_QUARTZ_ORE;
    public static List<AbstractConfig> CONFIGS;
    public static Map<String, ArmorConfig> ARMOR_CONFIGS;
    public static List<OreConfig> ORE_CONFIGS;

    public static IArmorConfig getArmorConfig(String name) {
        return ARMOR_CONFIGS.get(name);
    }

    private static void registerOreGeneration() {
    }

    private static void registerMobConfigs() {
        DEER_CONFIG = new MobConfig("Deer", 6, 2, 4, Arrays.asList("forest", "icy", "taiga", "plains"));
        SPROUT_CONFIG = new MobConfig("Sprout", 2, 2, 4, Arrays.asList("jungle", "river", "forest", "beach"));
        HELL_SPROUT_CONFIG = new HellSproutConfig("Hell Sprout", 2, 1, 1, Collections.singletonList("nether"), 100);
        SILVER_FOX_CONFIG = new MobConfig("Silver Fox", 4, 1, 3, Arrays.asList("forest", "icy", "taiga"));
        BEETLE_CONFIG = new MobConfig("Beetle", 5, 2, 4, Arrays.asList("swamp", "jungle", "forest", "plains"));
        FROG_CONFIG = new MobConfig("Frog", 6, 2, 4, Arrays.asList("swamp", "jungle", "beach", "river"));
        ENDERMINI_CONFIG = new MobConfig("Endermini", 2, 1, 2, Collections.singletonList("end"), BiomeDictionary.Type.END);
        OWL_CONFIG = new MobConfig("Owl", 9, 1, 3, Arrays.asList("taiga", "extreme_hills", "forest", "icy"));
        LAVA_CAT_CONFIG = new MobConfig("Lava Cat", 2, 1, 1, Collections.singletonList("nether"), BiomeDictionary.Type.NETHER);
        SILKWORM_CONFIG = new SilkwormConfig(true, 65, 1, 68);
        DUCK_CONFIG = new MobConfig("Duck", 5, 1, 4, Arrays.asList("wet", "swamp", "river", "beach"));
        HAT_CONFIG = new HatConfig();
        CLAM_CONFIG = new ClamConfig("Clam", 2, 1, 1, Arrays.asList("ocean", "river", "beach", "swamp", "wet"), 31, 2300, 5100);
        DEER_CONFIG.apply(COMMON_BUILDER);
        SPROUT_CONFIG.apply(COMMON_BUILDER);
        HELL_SPROUT_CONFIG.apply(COMMON_BUILDER);
        SILVER_FOX_CONFIG.apply(COMMON_BUILDER);
        BEETLE_CONFIG.apply(COMMON_BUILDER);
        FROG_CONFIG.apply(COMMON_BUILDER);
        ENDERMINI_CONFIG.apply(COMMON_BUILDER);
        OWL_CONFIG.apply(COMMON_BUILDER);
        LAVA_CAT_CONFIG.apply(COMMON_BUILDER);
        SILKWORM_CONFIG.apply(COMMON_BUILDER);
        DUCK_CONFIG.apply(COMMON_BUILDER);
        CLAM_CONFIG.apply(COMMON_BUILDER);
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    public static void configReload(ModConfigEvent event) {
        CONFIGS.forEach(AbstractConfig::reset);
        ModFeatures.ORE_FEATURES = null;
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent.Reloading event) {
        ConfigManager.configReload((ModConfigEvent)event);
    }

    @SubscribeEvent
    public static void onConfigLoaded(ModConfigEvent.Loading event) {
        ConfigManager.configReload((ModConfigEvent)event);
    }

    static {
        CONFIGS = new ArrayList<AbstractConfig>();
        ARMOR_CONFIGS = new HashMap<String, ArmorConfig>();
        List<ResourceKey<Level>> defaultDimensions = Collections.singletonList(Level.f_46428_);
        COMMON_BUILDER.comment("Ore Generation").push("oregen");
        TIN_ORE = new OreConfig("Tin", 7, 40, 180, 8, defaultDimensions);
        SILVER_ORE = new OreConfig("Silver", 4, -64, 64, 8, defaultDimensions);
        LEAD_ORE = new OreConfig("Lead", 4, -32, 50, 8, defaultDimensions);
        SAPPHIRE_ORE = new OreConfig("Sapphire", 4, -64, 50, 3, defaultDimensions);
        GRANITE_QUARTZ_ORE = new OreConfig("Quartz", 30, -64, 256, 2, defaultDimensions);
        ORE_CONFIGS = List.of(TIN_ORE, SILVER_ORE, LEAD_ORE, SAPPHIRE_ORE, GRANITE_QUARTZ_ORE);
        TIN_ORE.apply(COMMON_BUILDER);
        SILVER_ORE.apply(COMMON_BUILDER);
        LEAD_ORE.apply(COMMON_BUILDER);
        SAPPHIRE_ORE.apply(COMMON_BUILDER);
        GRANITE_QUARTZ_ORE.apply(COMMON_BUILDER);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Mob Spawn Configuration").push("mob_spawns");
        ConfigManager.registerMobConfigs();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Hat Configuration").push("hat_config");
        HAT_CONFIG.apply(COMMON_BUILDER);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Armor Configuration").push("armor_config");
        ARMOR_CONFIGS.put("sapphire", new ArmorConfig("sapphire", 3, 6, 8, 3, 2.0f));
        ARMOR_CONFIGS.put("copper", new ArmorConfig("copper", 2, 5, 6, 2, 0.0f));
        ARMOR_CONFIGS.put("lead", new ArmorConfig("lead", 2, 5, 6, 2, 1.0f));
        ARMOR_CONFIGS.put("orichalcum", new ArmorConfig("orichalcum", 1, 3, 5, 2, 0.0f));
        ARMOR_CONFIGS.put("silver", new ArmorConfig("silver", 1, 3, 5, 2, 0.0f));
        ARMOR_CONFIGS.put("tin", new ArmorConfig("tin", 1, 4, 5, 2, 0.0f));
        ARMOR_CONFIGS.put("carapace", new ArmorConfig("carapace", 2, 5, 6, 2, 0.0f));
        ARMOR_CONFIGS.put("antler", new ArmorConfig("antler", 3, 0, 0, 0, 1.0f));
        ARMOR_CONFIGS.values().forEach(o -> o.apply(COMMON_BUILDER));
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Feature Spawn Configuration").push("feature_spawns");
        DEAD_TREE_CONFIG = new TreeConfig(0.02, Arrays.asList(BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.WASTELAND), Arrays.asList(BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END), defaultDimensions);
        DEAD_TREE_CONFIG.apply(COMMON_BUILDER);
        STONEPETAL_CONFIG = (StonepetalConfig)new StonepetalConfig(1, 7, Arrays.asList(BiomeDictionary.Type.MOUNTAIN), Arrays.asList(BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END), defaultDimensions).setSupplierFeature(() -> null);
        STONEPETAL_CONFIG.apply(COMMON_BUILDER);
        HUT_CONFIG = (StructureConfig)new StructureConfig("hut", Arrays.asList(BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.PLAINS), Arrays.asList(BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END)).setStructure(() -> null);
        HUT_CONFIG.apply(COMMON_BUILDER);
        BARROW_CONFIG = (StructureConfig)new StructureConfig("barrow", Arrays.asList(BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.PLAINS), Arrays.asList(BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END)).setStructure(() -> null);
        BARROW_CONFIG.apply(COMMON_BUILDER);
        SAND_HOUSE_CONFIG = (StructureConfig)new StructureConfig("sand_house", Arrays.asList(BiomeDictionary.Type.SANDY), Arrays.asList(BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END)).setStructure(() -> null);
        SAND_HOUSE_CONFIG.apply(COMMON_BUILDER);
        SEED_INJECTION = COMMON_BUILDER.comment("Whether or not the aubergine loot table is injected into the grass seed table").define("seed_injection", true);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

