/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Random;
import javax.annotation.Nonnull;
import mysticmods.mysticalworld.client.model.EnderminiModel;
import mysticmods.mysticalworld.client.model.ModelHolder;
import mysticmods.mysticalworld.entity.EnderminiEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class EnderminiRenderer
extends MobRenderer<EnderminiEntity, EnderminiModel<EnderminiEntity>> {
    private static final ResourceLocation ENDERMINI_TEXTURES = new ResourceLocation("mysticalworld", "textures/entity/endermini.png");
    private final Random rnd = new Random();

    public EnderminiRenderer(EntityRendererProvider.Context context) {
        super(context, new EnderminiModel(context.m_174023_(ModelHolder.ENDERMINI)), 0.35f);
        this.m_115326_((RenderLayer)new EnderminiEyesLayer(this));
        this.m_115326_(new HeldBlockLayer((RenderLayerParent<EnderminiEntity, EnderminiModel<EnderminiEntity>>)this));
    }

    @Nonnull
    public Vec3 getRenderOffset(EnderminiEntity pEntity, float pPartialTicks) {
        if (pEntity.isScreaming()) {
            return new Vec3(this.rnd.nextGaussian() * 0.02, 0.0, this.rnd.nextGaussian() * 0.02);
        }
        return super.m_7860_((Entity)pEntity, pPartialTicks);
    }

    public void render(EnderminiEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack stack, MultiBufferSource pBuffer, int pPackedLight) {
        BlockState blockstate = pEntity.getHeldBlockState();
        EnderminiModel endermanmodel = (EnderminiModel)this.m_7200_();
        endermanmodel.f_102576_ = blockstate != null;
        endermanmodel.f_102577_ = pEntity.isScreaming();
        stack.m_85836_();
        stack.m_85841_(0.4f, 0.4f, 0.4f);
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, stack, pBuffer, pPackedLight);
        stack.m_85849_();
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull EnderminiEntity entity) {
        return ENDERMINI_TEXTURES;
    }

    public static class EnderminiEyesLayer<T extends LivingEntity>
    extends EyesLayer<T, EnderminiModel<T>> {
        private static final RenderType SKIN = RenderType.m_110488_((ResourceLocation)new ResourceLocation("textures/entity/enderman/enderman_eyes.png"));

        public EnderminiEyesLayer(RenderLayerParent<T, EnderminiModel<T>> p_i50939_1_) {
            super(p_i50939_1_);
        }

        public RenderType m_5708_() {
            return SKIN;
        }
    }

    public static class HeldBlockLayer
    extends RenderLayer<EnderminiEntity, EnderminiModel<EnderminiEntity>> {
        public HeldBlockLayer(RenderLayerParent<EnderminiEntity, EnderminiModel<EnderminiEntity>> layerParent) {
            super(layerParent);
        }

        public void render(@Nonnull PoseStack pMatrixStack, @Nonnull MultiBufferSource pBuffer, int pPackedLight, EnderminiEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            BlockState blockstate = pLivingEntity.getHeldBlockState();
            if (blockstate != null) {
                pMatrixStack.m_85836_();
                pMatrixStack.m_85837_(0.0, 0.6875, -0.75);
                pMatrixStack.m_85845_(Vector3f.f_122223_.m_122240_(20.0f));
                pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(45.0f));
                pMatrixStack.m_85837_(0.25, 0.1875, 0.25);
                pMatrixStack.m_85841_(-0.5f, -0.5f, 0.5f);
                pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                Minecraft.m_91087_().m_91289_().renderSingleBlock(blockstate, pMatrixStack, pBuffer, pPackedLight, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
                pMatrixStack.m_85849_();
            }
        }
    }
}

