/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.client.model.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.EnumMap;
import javax.annotation.Nullable;
import mysticmods.mysticalworld.client.model.ModelHolder;
import mysticmods.mysticalworld.client.model.armor.AntlerHatModel;
import mysticmods.mysticalworld.client.model.armor.BeetleArmorModel;
import mysticmods.mysticalworld.init.ModItems;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArmorModel
extends HumanoidModel<LivingEntity> {
    private static ArmorModel antlerModel = null;
    private static EnumMap<EquipmentSlot, ArmorModel> beetleModels = null;
    protected final EquipmentSlot slot;

    public static void init(EntityRendererProvider.Context context) {
        antlerModel = new AntlerHatModel(context.m_174023_(ModelHolder.ANTLER_ARMOR));
        beetleModels = new EnumMap(EquipmentSlot.class);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            beetleModels.put(slot, new BeetleArmorModel(context.m_174023_(ModelHolder.BEETLE_ARMOR), slot));
        }
    }

    @Nullable
    public static ArmorModel getModel(ItemStack stack) {
        if (stack.m_150930_((Item)ModItems.ANTLER_HAT.get())) {
            return antlerModel;
        }
        if (stack.m_150930_((Item)ModItems.BEETLE_BOOTS.get()) || stack.m_150930_((Item)ModItems.BEETLE_HELMET.get()) || stack.m_150930_((Item)ModItems.BEETLE_CHESTPLATE.get()) || stack.m_150930_((Item)ModItems.BEETLE_LEGGINGS.get())) {
            return beetleModels.get(stack.getEquipmentSlot());
        }
        return null;
    }

    public ArmorModel(ModelPart root, EquipmentSlot slot) {
        super(root);
        this.slot = slot;
    }

    public void m_6973_(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(entity instanceof ArmorStand)) {
            super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            return;
        }
        ArmorStand entityIn = (ArmorStand)entity;
        this.f_102808_.f_104203_ = (float)Math.PI / 180 * entityIn.m_31680_().m_123156_();
        this.f_102808_.f_104204_ = (float)Math.PI / 180 * entityIn.m_31680_().m_123157_();
        this.f_102808_.f_104205_ = (float)Math.PI / 180 * entityIn.m_31680_().m_123158_();
        this.f_102808_.m_104227_(0.0f, 1.0f, 0.0f);
        this.f_102810_.f_104203_ = (float)Math.PI / 180 * entityIn.m_31685_().m_123156_();
        this.f_102810_.f_104204_ = (float)Math.PI / 180 * entityIn.m_31685_().m_123157_();
        this.f_102810_.f_104205_ = (float)Math.PI / 180 * entityIn.m_31685_().m_123158_();
        this.f_102812_.f_104203_ = (float)Math.PI / 180 * entityIn.m_31688_().m_123156_();
        this.f_102812_.f_104204_ = (float)Math.PI / 180 * entityIn.m_31688_().m_123157_();
        this.f_102812_.f_104205_ = (float)Math.PI / 180 * entityIn.m_31688_().m_123158_();
        this.f_102811_.f_104203_ = (float)Math.PI / 180 * entityIn.m_31689_().m_123156_();
        this.f_102811_.f_104204_ = (float)Math.PI / 180 * entityIn.m_31689_().m_123157_();
        this.f_102811_.f_104205_ = (float)Math.PI / 180 * entityIn.m_31689_().m_123158_();
        this.f_102814_.f_104203_ = (float)Math.PI / 180 * entityIn.m_31691_().m_123156_();
        this.f_102814_.f_104204_ = (float)Math.PI / 180 * entityIn.m_31691_().m_123157_();
        this.f_102814_.f_104205_ = (float)Math.PI / 180 * entityIn.m_31691_().m_123158_();
        this.f_102814_.m_104227_(1.9f, 11.0f, 0.0f);
        this.f_102813_.f_104203_ = (float)Math.PI / 180 * entityIn.m_31694_().m_123156_();
        this.f_102813_.f_104204_ = (float)Math.PI / 180 * entityIn.m_31694_().m_123157_();
        this.f_102813_.f_104205_ = (float)Math.PI / 180 * entityIn.m_31694_().m_123158_();
        this.f_102813_.m_104227_(-1.9f, 11.0f, 0.0f);
        this.f_102809_.m_104315_(this.f_102808_);
    }

    public void m_7695_(PoseStack ms, VertexConsumer buffer, int light, int overlay, float r, float g, float b, float a) {
        this.setPartVisibility(this.slot);
        super.m_7695_(ms, buffer, light, overlay, r, g, b, a);
    }

    protected void setPartVisibility(EquipmentSlot slot) {
        this.m_8009_(false);
        switch (slot) {
            case HEAD: {
                this.f_102808_.f_104207_ = true;
                this.f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                this.f_102810_.f_104207_ = true;
                this.f_102811_.f_104207_ = true;
                this.f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                this.f_102810_.f_104207_ = true;
                this.f_102813_.f_104207_ = true;
                this.f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                this.f_102813_.f_104207_ = true;
                this.f_102814_.f_104207_ = true;
            }
        }
    }
}

