/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.client.model;

import com.google.common.collect.ImmutableList;
import mysticmods.mysticalworld.entity.SproutEntity;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.phys.Vec3;

public class SproutModel
extends AgeableListModel<SproutEntity> {
    private final ModelPart head;
    private final ModelPart legL;
    private final ModelPart legR;
    private final ModelPart leafTop;
    private final ModelPart leafBottom;

    public SproutModel(ModelPart pRoot) {
        super(true, 5.0f, 2.0f);
        this.head = pRoot.m_171324_("head");
        this.legL = pRoot.m_171324_("left_leg");
        this.legR = pRoot.m_171324_("right_leg");
        this.leafTop = pRoot.m_171324_("leaf_top");
        this.leafBottom = pRoot.m_171324_("leaf_bottom");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171481_(-2.5f, 0.0f, -2.5f, 5.0f, 5.0f, 5.0f).m_171480_(), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f).m_171480_(), PartPose.m_171419_((float)1.5f, (float)16.0f, (float)0.0f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f).m_171480_(), PartPose.m_171419_((float)-1.5f, (float)16.0f, (float)0.0f));
        partdefinition.m_171599_("leaf_top", CubeListBuilder.m_171558_().m_171514_(8, 0).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f).m_171480_(), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)-1.0f));
        partdefinition.m_171599_("leaf_bottom", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171481_(-1.5f, -0.5f, -0.5f, 3.0f, 4.0f, 1.0f).m_171480_(), PartPose.m_171423_((float)0.0f, (float)9.0f, (float)-1.0f, (float)1.963495f, (float)0.5235988f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.head, (Object)this.leafTop, (Object)this.leafBottom, (Object)this.legL, (Object)this.legR);
    }

    public void setupAnim(SproutEntity entity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        float speed = (float)Math.min(0.25, new Vec3(entity.m_20184_().f_82479_, 0.0, entity.m_20184_().f_82481_).m_82553_() * 4.0);
        this.legL.f_104203_ = -((float)Math.toRadians(speed * 240.0f * (float)Math.sin(Math.toRadians(pAgeInTicks % 360.0f) * 24.0)));
        this.legR.f_104203_ = (float)Math.toRadians(speed * 240.0f * (float)Math.sin(Math.toRadians(pAgeInTicks % 360.0f) * 24.0));
    }
}

